@php
  $taxonomies = App::get_decor_taxonomies();
  $tints = get_post_meta(get_the_ID(), '_tinte', true);

  if(!is_array($tints)) {
    $tints = json_decode($meta, true);
  }
@endphp

<article {!! post_class('decor-single') !!}>
  <div class="container">
    @include('partials/page-header', ['is_decor' => true])
    @include('partials.decor.decor-development', ['tints' => $tints])
    @include('partials.decor.decor-gallery', ['tints' => $tints])
    @include('partials.decor.decor-gallery-flooring', ['tints' => $tints])
    <div class="info">
      @include('partials.decor.decor-preview', ['tints' => $tints])
      <div class="content">
        @include('partials.decor.decor-sheet', ['tints' => $tints, 'taxonomies' => $taxonomies])
        @include('partials.decor.decor-inuse', ['tints' => $tints])
        @include('partials.decor.decor-inuse-flooring', ['tints' => $tints])
        @include('partials.decor.decor-additional', ['tints' => $tints])
        </div>
      </div>
    </div>
  </div>
</article>
