<div
    class="decor-filter desktop">
    @if(!$is_list_block)
        <div class="filters">
            <span>{!! __('Filters', 'thor') !!}</span>
            @svg('images/more.svg')
        </div>
    @endif
    <div class="active-filters">
        @php
            $is_filter = true;
            $counter = 0;
            $taxonomies = App::get_decor_taxonomies($is_filter);
        @endphp
        @foreach($taxonomies as $slug => $taxonomy)
            @php
                $active_filters = $_GET[$slug];
                if($active_filters) {
                    $counter += count($active_filters);
                    $is_active = true;
                }
            @endphp
            @if($active_filters)
                <div class="single-filter">
                    @foreach($active_filters as $key => $filter)
                    @php
                        $term = get_term_by('slug', $filter, $slug);
                    @endphp
                        <a class="remove_filter" href="{!! App::remove_single_query_arg($slug, $filter) !!}">
                            <span>
                                {!! $taxonomy . ': ' !!}
                            </span>
                            <span>
                                {!! App::cast_taxonomy_term($slug, $term) !!}
                            </span>
                            @svg('images/close.svg')
                        </a>
                    @endforeach
                </div>
            @endif
        @endforeach
        @if($is_active && $counter > 1)
            <div class="single-filter">
                <a class="remove_filter" href="{!! get_post_type_archive_link('decor') !!}">
                    <span>{!! __('Remove all', 'thor') !!}</span>
                    @svg('images/close.svg')
                </a>
            </div>
        @endif
    </div>
    <div class="decor-info">
        <div class="decor-grid">
            <span>{!! __('View', 'thor') !!}</span>
            <div>
                <a data-grid="grid-large">2</a>
                <a data-grid="grid-small" >4</a>
            </div> 
        </div>
    </div>
</div>

<div
    class="decor-filter mobile">
    @if(!$is_list_block)
        <div class="filters">
            @svg('images/filter.svg')
        </div>
    @endif
    <div class="decor-info">
        <div class="decor-grid">
            <span>{!! __('View', 'thor') !!}</span>
            <div>
                <a data-grid="grid-large">1</a>
                <a data-grid="grid-small" >2</a>
            </div> 
        </div>
    </div>
</div>