@php
    $description = get_field('description', $post);
    $link = get_field('link', $post);

    $terms = get_the_terms($post->ID, 'downloads-category');
@endphp

<article {{post_class('teaser teaser-downloads '. $type)}}>
    @if($link)
        <a href="{!! $link['url'] !!}"
            target="_blank"
            download>
    @else
        <a class="without-link">
    @endif

        @if($type == 'image')
                <figure>
                    <img
                        class="lazy"
                        src="{!! get_the_post_thumbnail_url(get_the_ID(), 'large') !!}"
                        data-src="{!! get_the_post_thumbnail_url(get_the_ID(), 'full') !!}"
                    />
                </figure>
        @endif
    
    <header>
        <div>
            @if(($type == 'short') && $terms)
                <div class="category">
                    @foreach($terms as $term)
                        @if($term->parent)
                            {!! $term->name !!}
                        @endif
                    @endforeach
                </div>
            @endif
            <h2>
                {!! get_the_title() !!}
            </h2>
            @if($type == 'search')
                <div class="category">
                    @if($terms)
                        @foreach($terms as $key => $term)
                            @if($key > 0)
                                {!! __('/', 'thor') !!}
                            @endif
                            {!! $term->name !!}
                        @endforeach
                    @else 
                        {!! __('No category', 'thor') !!}
                    @endif
                </div>
            @endif
            @if($type != 'short' && $type != 'search')
                <div class="mt-2 description">
                    {!! $description !!}
                </div>
            @endif
            @if($type == 'image' || $type == 'short') 
                <div class="md:mt-1 size">
                    <span>
                        {{ __('Size: ') }}
                    </span>
                    @if($link)
                        {!! App::human_filesize($link['filesize']) !!}
                    @else 
                        {!! __('0.0') !!}
                    @endif
                </div>
            @endif
        </div>
        @if($type == 'long')
            <a 
                href="{!! $link['url'] !!}"
                target="_blank"
                download
                class="download">

                <p>
                    {{ __('Download', 'thor') }}
                </p>

                @svg('images/arrow-down.svg')

            </a>
        @elseif($type == 'short')
            <div class="arrow">
                @svg('images/arrow-down.svg')
            </div>
        @endif
    </header>

    </a>
</article>
