<?php

namespace App;

function get_pattern_html($filename)
{
  $file = "../app/gutenberg/patterns/{$filename}.php";
  $path = locate_template($file);
  $output = file_get_contents($path, true);

  return $output;
}

add_action('init', function () {
  if(function_exists('register_block_pattern_category')) {
    register_block_pattern_category(
      'custom',
      array('label' => __('Custom', 'thor'))
    );
  }

  if (function_exists('register_block_pattern')) {
    register_block_pattern(
      'thor/first-pattern',
      array(
        'title'       => __('First Pattern', 'thor'),
        'categories'  => ['header', 'custom'],
        'description' => __('', 'thor'),
        'content'     => get_pattern_html('first-pattern'),
      )
    );
  }
});
