  export function calculateAspectRatio(img, figure) {
    figure.style.height = '100%'
    figure.style.width = 'auto'

    let dimensions = getObjectFitSize(true, img.width, img.height, img.naturalWidth, img.naturalHeight)
    let width = dimensions.width
    let height = dimensions.height

    figure.style.height = `${height}px`
    figure.style.width = `${width}px`
  }

  export function getObjectFitSize(contains, containerWidth, containerHeight, width, height) {
    var doRatio = width / height;
    var cRatio = containerWidth / containerHeight;
    var targetWidth = 0;
    var targetHeight = 0;
    var test = contains ? (doRatio > cRatio) : (doRatio < cRatio);

    if (test) {
      targetWidth = containerWidth;
      targetHeight = targetWidth / doRatio;
    } else {
      targetHeight = containerHeight;
      targetWidth = targetHeight * doRatio;
    }

    return {
      width: targetWidth,
      height: targetHeight,
      x: (containerWidth - targetWidth) / 2,
      y: (containerHeight - targetHeight) / 2,
    };
  }
