@php
  $terms = get_the_terms($post->ID, 'decors-category');
  $highlights = get_the_terms($post->ID, 'highlights');
  $is_new = $highlights[0]->slug;
@endphp

<article {{post_class('teaser teaser-decor')}}>
    <figure>
      <a href="{{ get_permalink($post) }}" title="{!! get_the_title($post) !!}">
        <div class="labels">
          @if($is_new && $show_highlight_label)
            <div class="new">
              {!! __('Highlights', 'thor') !!}
            </div>
          @endif
          @if($terms)
            <div class="archive-category @if(!$is_new) transition-all @endif">
              {!! $terms[0]->name !!}
            </div>
          @endif
        </div>
        @if (has_post_thumbnail($post))
          <img
            class="lazy"
            src="{!! get_the_post_thumbnail_url($post, 'large') !!}"
            data-src="{!! get_the_post_thumbnail_url($post, 'full') !!}"
          />
        @endif
      </a>
    </figure>
  
  <header>
    <a href="{{ get_permalink($post) }}" title="{!! get_the_title($post) !!}">
      <h2>
        {!! get_the_title($post) !!}
      </h2>
    </a>
    @if($terms && $show_category)
      <div class="category">
        @foreach($terms as $key => $term)
            @if($key > 0)
                {!! __('/', 'thor') !!}
            @endif
            {!! $term->name !!}
        @endforeach
      </div>
    @endif
  </header>
</article>
