
const { __ } = wp.i18n

wp.domReady( () => {
    wp.blocks.unregisterBlockType('core/latest-posts');
    wp.blocks.unregisterBlockType('core/latest-comments');
    wp.blocks.unregisterBlockType('core/archives');
    wp.blocks.unregisterBlockType('core/post-author');
    wp.blocks.unregisterBlockType('core/post-author-biography');
    wp.blocks.unregisterBlockType('core/post-author-name');
    wp.blocks.unregisterBlockType('core/post-comments');
    wp.blocks.unregisterBlockType('core/post-comments-count');
    wp.blocks.unregisterBlockType('core/post-comments-form');
    wp.blocks.unregisterBlockType('core/post-comments-link');
    wp.blocks.unregisterBlockType('core/post-date');
    wp.blocks.unregisterBlockType('core/post-excerpt');
    wp.blocks.unregisterBlockType('core/post-featured-image');
    wp.blocks.unregisterBlockType('core/post-content');
    wp.blocks.unregisterBlockType('core/site-tagline');
    wp.blocks.unregisterBlockType('core/gallery');
    wp.blocks.unregisterBlockType('core/post-navigation-link');
    wp.blocks.unregisterBlockType('core/term-description');
    wp.blocks.unregisterBlockType('core/post-template');
    wp.blocks.unregisterBlockType('core/post-terms');
    wp.blocks.unregisterBlockType('core/posts-list');
    wp.blocks.unregisterBlockType('core/post-title');
    wp.blocks.unregisterBlockType('core/query');

    wp.blocks.unregisterBlockStyle('core/button', 'fill')
    wp.blocks.unregisterBlockStyle('core/button', 'outline')


    const el = wp.element.createElement;
    const SVG = wp.primitives.SVG;

    const iconColumnsCards = el(
      SVG, {
        width: 48,
        height: 48,
        viewBox: '0 0 48 48',
      },
      el('path', {
        fillRule: 'evenodd',
        clipRule: 'evenodd',
        d: 'M41 14a2 2 0 0 0-2-2H9a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h30a2 2 0 0 0 2-2V14zM28.5 34h-9V14h9v20zm2 0V14H39v20h-8.5zm-13 0H9V14h8.5v20z',
      })
    );

    wp.blocks.registerBlockStyle('core/buttons', {
      name: 'inline',
      label: 'Bottoni Inline',
    });

    wp.blocks.registerBlockStyle('core/button', {
      name: 'outline',
      label: 'Bottone Outline',
    });

    wp.blocks.registerBlockStyle('core/button', {
      name: 'fill',
      label: 'Bottone Pieno',
    });

    wp.blocks.registerBlockStyle('core/button', {
      name: 'arrow',
      label: 'Bottone con freccia',
    });

    wp.blocks.registerBlockStyle('core/button', {
      name: 'arrow-light',
      label: 'Bottone con freccia light',
    });

    wp.blocks.registerBlockStyle('core/button', {
      name: 'light',
      label: 'Bottone Light',
    });

    wp.blocks.registerBlockStyle('core/video', {
      name: 'black',
      label: 'Player Black',
    });

    wp.blocks.registerBlockStyle('core/video', {
      name: 'light',
      label: 'Player Light',
    });

    wp.blocks.registerBlockStyle('core/spacer', {
      name: 'big',
      label: 'Big (80px - mobile 60px)',
    });

    wp.blocks.registerBlockStyle('core/cover', {
      name: 'hero',
      label: 'Hero',
    });

    wp.blocks.registerBlockStyle('core/cover', {
      name: 'hero-with-arrow',
      label: 'Hero con freccia nera verso il basso',
    });

    wp.blocks.registerBlockStyle('core/cover', {
      name: 'hero-with-arrow-white',
      label: 'Hero con freccia bianca verso il basso',
    });

    wp.blocks.registerBlockStyle('core/spacer', {
      name: 'medium',
      label: 'Medium (60px - mobile 30px)',
    });

});