import {gsap, Power1} from 'gsap'

export default (() => {
    const mainHeader = document.querySelector('.main-header')
    const logoSvg = mainHeader.querySelector('.logo svg')

    const t1 = gsap.timeline()

    t1.to(logoSvg, {
        height: '2.25rem',
        duration: 0.15,
        ease: Power1.easeInOut,
    })

    t1.pause()

    window.addEventListener('scroll', () => {
        if (window.scrollY > 400 && window.innerWidth > 1023) {
            t1.play()
        } else {
            t1.reverse()
        }
    })
})()