{{--
  Template Name: Page with required form submission
--}}

@extends('layouts.app', ['hide_newsletter' => true])

@php
  $form_id = get_field('form');
  $small_text = get_field('small_text');
  $text = get_field('text');

@endphp

@section('content')
  @while(have_posts()) @php the_post() @endphp
    <div class="container">
      <div class="form-wrapper">
        <div class="page-header">
          @if ($small_text)
            <h1 class="page-title">{{ $small_text }}</h1>
          @endif
          @if ($text)
            <h2 class="page-subtitle spaced">{{ $text }}</h2>
          @endif
        </div>

        {!! gravity_form($form_id, false, false, false, '', true, 1); !!}
      </div>

      <div class="post-content-wrapper">
        {!! the_content() !!}
      </div>
    </div>
  @endwhile

  
  @while(have_posts())
    @php the_post() @endphp
  @endwhile
@endsection
