@if ($is_blog)
  <div class="page-header">
    @if (function_exists('yoast_breadcrumb'))
      @php yoast_breadcrumb( '<p class="breadcrumb">','</p>' ) @endphp
    @endif
    <h1 class="page-title">
      {!! single_post_title() !!}
    </h1>
    @php
      $archive_subtitle = get_field('archive_subtitle', 'option');
    @endphp
    <div class="page-subtitle">
      {!! $archive_subtitle !!}
    </div>
  </div>
@endif

@if ($is_search)
  <div class="page-header">
    @if (function_exists('yoast_breadcrumb'))
      @php yoast_breadcrumb( '<p class="breadcrumb">','</p>' ) @endphp
    @endif
    <h1 class="page-title">
      {!! App::title() !!}
    </h1>
    <div class="page-subtitle spaced">
      {!! $description !!}
    </div>
  </div>
@endif

@if ($is_archive)
  <div class="page-header">
    @if (function_exists('yoast_breadcrumb'))
      @php yoast_breadcrumb( '<p class="breadcrumb">','</p>' ) @endphp
    @endif
    <h1 class="page-title">
      {!! App::title() !!}
    </h1>
    @if ($queried_object instanceof WP_Term)
      <div class="page-subtitle spaced">
        {!! $queried_object->description !!}
      </div>
    @else
      <div class="page-subtitle spaced">
        {!! $description !!}
      </div>
    @endif
  </div>
@endif

@if ($is_product)
  <div class="page-header">
    @if (function_exists('yoast_breadcrumb'))
      @php yoast_breadcrumb( '<p class="breadcrumb">','</p>' ) @endphp
    @endif
    <h1 class="page-title">
      {!! App::title() . ' ' . $title_extended !!}
    </h1>
    <div class="page-subtitle spaced">
      <div class="max-w-5xl">
        {!! $description !!}
      </div>
    </div>
  </div>
@endif

@if ($is_single)
  <div class="page-header">
    @if (function_exists('yoast_breadcrumb'))
      @php yoast_breadcrumb( '<p class="breadcrumb">','</p>' ) @endphp
    @endif
    <h1 class="mb-4 page-title">
      {!! single_post_title() !!}
    </h1>
  </div>
@endif

@if ($is_decor)
  @php
    $is_new = get_the_terms($post, 'highlights');
    $code = get_post_meta(get_the_ID(), '_codice', true);
    
    if (!$code) {
        $code = get_post_meta(get_the_ID(), '_codice_temporaneo', true);
    }
    
  @endphp
  <div class="page-header">

    @if (function_exists('yoast_breadcrumb'))
      @php yoast_breadcrumb( '<p class="breadcrumb">','</p>' ) @endphp
    @endif
    <div class="title">
      <h1 class="mb-4 page-title">
        {!! single_post_title() !!} {{ $code ? $code : '' }}
      </h1>
      @if (boolval($is_new[0]->slug) == true)
        <div class="new-in">
          <h3>{!! __('Highlights', 'thor') !!}</h3>
        </div>
      @endif
    </div>
  </div>
@endif

@if ($default)
  <div class="page-header">
    @if (function_exists('yoast_breadcrumb'))
      @php yoast_breadcrumb( '<p class="breadcrumb">','</p>' ) @endphp
    @endif
  </div>
@endif
