import zoom from 'jquery-zoom'
import * as Helpers from './decor-helpers'

export default (() => {
    const decorSingle = document.querySelectorAll('.decor-single')


    decorSingle.forEach(single => {
        if(single) {
            const icons = single.querySelectorAll('.icons .icon, .zoom-decor .icon')
            const dataDecor = single.querySelectorAll('[data-decor]')
        
            icons.forEach(icon => {
                icon.addEventListener('click', (i) => {
                    const dataIcon = icon.dataset.decor
                    changeDecor(dataIcon)
                })
            })
            const development = single.querySelectorAll('.zoom-development .development')
    
            window.addEventListener('load', () => {
                $(development).zoom({
                    magnify: 1.5,
                    callback: function () {
                        development.forEach(single => {
                            const developmentImg = single.querySelector('img')
                            if (developmentImg) {
                                Helpers.calculateAspectRatio(developmentImg, single)
                                window.addEventListener('resize', () => {
                                    Helpers.calculateAspectRatio(developmentImg, single)
                                })
                            }
                        })
                    },
                })
            })
    
            function changeDecor(dataIcon) {
                icons.forEach(icon => {
                  icon.classList.remove('active')
                  if (icon.dataset.decor == dataIcon) {
                    icon.classList.add('active')
                  }
                })
    
                dataDecor.forEach(data => {
                    data.classList.remove('active')
                    if(data.dataset.decor == dataIcon) {
                        data.classList.add('active')
                    }
    
                    development.forEach(single => {
                        const developmentImg = single.querySelector('img')
                            if (developmentImg) {
                            Helpers.calculateAspectRatio(developmentImg, single)
                        }
                    })
                })
            }
        }
    })
})()