import { gsap } from 'gsap'
import { getCookie } from '../util/utils'


export default (() => {
    const currentLocation = document.location
    const cookieName = 'pageRequiredFormSubmission'
    const pages = $('.page-required-form-submission')

    pages.each((index, page) => {
        const formWrapper = $(page).find('.form-wrapper')
        const contentWrapper = $(page).find('.post-content-wrapper')
        const form = formWrapper.find('form')
        const initialSubmissionCookie = getCookie(cookieName)

        console.log('initialSubmissionCookie', initialSubmissionCookie, contentWrapper)

        if (initialSubmissionCookie === 'submitted') {
            showContent()
        } else {
            showForm()
            $(document).on('gform_confirmation_loaded', function (event, formId) {
                showContent()

                document.cookie = `${cookieName}=submitted;domain=;path=${currentLocation.pathname}`
            });
        }

        function showContent() {
            gsap.to(contentWrapper, {
                display: 'block',
            })
        }

        function showForm() {
            gsap.to(formWrapper, {
                display: 'block',
            })
        }
        

    })

})()
