import Swiper from 'swiper';
import SwiperCore, { Navigation, Pagination, Scrollbar, EffectFade } from 'swiper/core';

SwiperCore.use([Navigation, Pagination, Scrollbar, EffectFade]);

export default (() => {
  const decorSingle = document.querySelectorAll('.decor-single')

  decorSingle.forEach(single => {
    if (single) {
      const highlight = single.querySelector('.images .highlight')
      const close = single.querySelector('.zoom [data-close]')
      let zoom = single.querySelector('.zoom')
  
      highlight.addEventListener('click', () => {
        zoom.classList.add('active')
      })
  
      close.addEventListener('click', () => {
        zoom.classList.remove('active')
      })
  
      window.addEventListener('load', () => {
        const highlightGallery = single.querySelectorAll('.flooring-use figure, .flooring-use figure')
        const closeGallery = single.querySelectorAll('.flooring-gallery [data-close]')
        let zoomGallery = single.querySelector('.flooring-gallery')
  
        highlightGallery.forEach(single => {
          const index = single.dataset.index
          single.addEventListener('click', () => {
            zoomGallery.classList.add('active')
          })
        })
  
        closeGallery.forEach(single => {
          single.addEventListener('click', () => {
            zoomGallery.classList.remove('active')
          })
        })
  
        const galleries = single.querySelectorAll('.flooring-gallery .inner, .flooring-use .inner')
        galleries.forEach(single => {
          const highlightGallery = single.querySelectorAll('.flooring-use figure, .flooring-use figure')
          highlightGallery.forEach(single => {
            const index = single.dataset.index
            single.addEventListener('click', () => {
              gallery.slideTo(index, 0)
            })
          })
  
          single.classList.add('initialize')
          let singlePrev = single.querySelector('.swiper-button-prev')
          let singleNext = single.querySelector('.swiper-button-next')
          const gallery = new Swiper(single, {
            navigation: {
              nextEl: singleNext,
              prevEl: singlePrev,
            },
            breakpoints: {
              1024: {
                allowTouchMove: false,
              },
            },
            scrollbar: {
              draggable: false,
            },
            effect: 'fade',
            fadeEffect: {
              crossFade: true,
            },
          });
          single.classList.remove('initialize')
        })
      })
    }
  })


})()
