import Swiper from 'swiper';
import SwiperCore, { Navigation, Pagination, Scrollbar, EffectFade } from 'swiper/core';

SwiperCore.use([Navigation, Pagination, Scrollbar, EffectFade]);

export default (() => {
  const decorSingle = document.querySelectorAll('.decor-single')

  decorSingle.forEach(single => {
    if (single) {
      const highlight = single.querySelector('.images .highlight')
      const close = single.querySelector('.zoom [data-close]')
      let zoom = single.querySelector('.zoom')
  
      highlight.addEventListener('click', () => {
        zoom.classList.add('active')
      })
  
      close.addEventListener('click', () => {
        zoom.classList.remove('active')
      })
  
      window.addEventListener('load', () => {
        const highlightGallery = single.querySelectorAll('.decors-use figure')
        const closeGallery = single.querySelectorAll('.gallery-use [data-close]')
        let zoomGallery = single.querySelector('.gallery-use')
  
        highlightGallery.forEach(single => {
          const index = single.dataset.index
          single.addEventListener('click', () => {
            zoomGallery.classList.add('active')
          })
        })
  
        closeGallery.forEach(single => {
          single.addEventListener('click', () => {
            zoomGallery.classList.remove('active')
          })
        })
  
        const galleries = single.querySelectorAll('.gallery-use .inner')
        galleries.forEach(single => {
          const highlightGallery = single.querySelectorAll('.decors-use figure')
          highlightGallery.forEach(single => {
            const index = single.dataset.index
            single.addEventListener('click', () => {
              gallery.slideTo(index, 0)
            })
          })
  
          single.classList.add('initialize')
          let singlePrev = single.querySelector('.swiper-button-prev')
          let singleNext = single.querySelector('.swiper-button-next')
          const gallery = new Swiper(single, {
            navigation: {
              nextEl: singleNext,
              prevEl: singlePrev,
            },
            scrollbar: {
              draggable: false,
            },
            breakpoints: {
              1024: {
                allowTouchMove: false,
              },
            },
            effect: 'fade',
            fadeEffect: {
              crossFade: true,
            },
          });
          single.classList.remove('initialize')
        })
      })
    }
  })


})()
