@php
  $block_info = App::get_block_info($block);

  $name = get_field('name');
  $icon = get_field('icon');
@endphp

<div id="{{ $block_info['id'] }}"
     class="{{ $block_info['classes'] }} accordion-inner">
    <div class="accordion-single">
        <div class="title">
            <h3>
                {!! $name !!}
            </h3>
            @if($icon)
                <div class="{!! $icon !!}">
                    @svg('images/'. $icon .'.svg')
                </div>
            @endif
        </div>
        <div class="content-accordion">
            @php
                $template = array(
                array( 'core/paragraph', array(
                        'placeholder' => __('Place the content of the accordion inside of this section'),
                        )
                ),
                );

                echo '<InnerBlocks template="' . esc_attr( wp_json_encode( $template ) ) . '" 
                />';
            @endphp
        </div>
    </div>
</div> 