@extends('layouts.app')

@section('content')
  <div class="container">
    @php
      $description = get_field('archive_collection_subtitle','option');
    @endphp
    @include('partials.page-header', ['is_archive' => true, 'description' => $description])

    @if (!have_posts())
    @else
      <div data-load-more class="grid-list two">
        @while (have_posts()) @php the_post() @endphp
          @php 
            $is_highlighted = get_field('is_highlighted');
          @endphp
          @if($is_highlighted)
            <div class="w-full is-highlighted">
          @else
            <div class="w-full">
          @endif
              @include('partials.teaser-'.get_post_type())
            </div>
        @endwhile
      </div><!--row-->
    @endif
    @include('partials.utils.infinite-loader')

    @if(function_exists('wp_pagenavi'))
      {!!  wp_pagenavi(); !!}
    @endif

  </div><!--container-->
@endsection
