@php
  $block_info = App::get_block_info($block);

  $filter = get_field('filter');
  $how_much = get_field('how_much');
  $layout = get_field('layout');
  $show_highlight_label = get_field('show_highlight_label');
  $highlights = get_field('highlights');

  $args = array(
      'post_type' => 'decor',
      'numberposts' => $how_much,
  );

  if($highlights == true) {
    $args['tax_query'][] = [
      'taxonomy' => 'highlights',
      'field' => 'slug',
      'terms' => '1',
    ];
  }

  switch ($filter) {
      case 'last':
            $posts = get_posts($args);
          break;

      case 'taxonomy':
            $taxonomy = get_field('taxonomy');
            $args['tax_query'][] = 
                [
                    'taxonomy' => 'decors-category',
                    'terms' => $taxonomy,
                ];

            $posts = get_posts($args);
          break;

      case 'specific':
            $posts = get_field('specific');
          break;

      default:
        break;
  }

@endphp

@if($posts)
    <div id="{{ $block_info['id'] }}"
        class="{{ $block_info['classes'] }} decor-list {!! $layout !!}">

        @if($layout == 'carousel')
            <div class="swiper-container decor">
                    <div class="arrow-container">
                        <div class="swiper-button-prev">
                        @svg('images/arrow-left.svg')
                        </div>
                        <div class="swiper-button-next">
                        @svg('images/arrow-right.svg')
                        </div>
                    </div>
                    <div class="swiper-wrapper">
                        @foreach($posts as $key => $post)
                            <div class="swiper-slide">
                                <div class="single">
                                    @include('partials.teaser-' . get_post_type($post))
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        @endif

    @if($layout == 'grid')
        <div class="flex flex-col">
            <div class="inner-list">
                <div class="decors-container" data-default="grid-small">
                    @php
                        global $post;
                    @endphp
                    @foreach($posts as $key => $post)
                        <div class="w-full">
                            @include('partials.teaser-'.get_post_type(), ['show_highlight_label' => $show_highlight_label])
                        </div>
                    @endforeach
                </div>
            </div>
            @include('partials.decor.decor-single-filter', ['taxonomy' => 'decors-category', 'post_type' => 'decor', 'is_list_block' => true])
        </div>
    @endif
@endif
