@php
    $activate_popup = get_field('activate_popup','option');
    $autoclose = get_field('autoclose','option');
    $how_long = get_field('how_long','option');

    $closed_background = get_field('closed_background','option');
    $closed_color = get_field('closed_color','option');
    $closed_subtitle = get_field('closed_subtitle','option');
    $closed_title = get_field('closed_title','option');

    $opened_background = get_field('opened_background','option');
    $opened_color = get_field('opened_color','option');
    $opened_subtitle = get_field('opened_subtitle','option');
    $opened_title = get_field('opened_title','option');
    $opened_image = get_field('opened_image','option');
    $opened_description = get_field('opened_description','option');
@endphp

@if($activate_popup)
    <div data-popup
         @if($activate_popup) data-activate-popup @endif
         data-autoclose="{!! $autoclose !!}"
         data-howlong="{!! $how_long !!}"
         class="popup">

        <div class="inner">
            <div
                style="background-color: {!! $opened_background !!};
                       color: {!! $opened_color !!}"
                class="content">
                <div class="popup-closer"> @svg('images/close.svg') </div>
                <div class="text">
                    <p class="subtitle">{!! $opened_subtitle !!}</p>
                    <div class="title">{!! $opened_title !!}</div>
                </div>
                <div class="description">{!! $opened_description !!}</div>
                <figure>
                    <img
                        class="lazy"
                        data-src="{!! $opened_image['sizes']['full'] !!}"
                        src="{!! $opened_image['sizes']['large'] !!}" />
                </figure>
            </div>
        </div>

    </div>
    <div data-popup 
         class="popup-opener"
         style="background-color: {!! $closed_background !!};
                color: {!! $closed_color !!}">

        <div class="inner">
            <p class="subtitle">{!! $closed_subtitle !!}</p>
            <h6 class="title">{!! $closed_title !!}</h6>
        </div>

        @svg('images/more.svg')

    </div>
@endif