@extends('layouts.app')

@section('content')
  <div class="container">
    @php
      $description = term_description(get_queried_object()) ? : '';
    @endphp
    @include('partials.page-header', ['is_archive' => true, 'description' => $description])

    <div class="flex flex-col list">
      @if (!have_posts())
      @else
        <div class="inner-list">
          <div class="decors-container" data-load-more data-default="grid-small">
            @php
              global $post;
              global $wp_query;
            @endphp
            @while (have_posts()) @php the_post() @endphp
                <div class="w-full">
                  @include('partials.teaser-'.get_post_type(), ['show_highlight_label' => true])
                </div>
            @endwhile
          </div>
        </div>
      @endif
      @include('partials.decor.decor-single-panel')
    </div>
    @include('partials.utils.infinite-loader')


    @if(function_exists('wp_pagenavi'))
      {!!  wp_pagenavi(); !!}
    @endif

  </div>
@endsection
