@php
  $block_info = App::get_block_info($block);

  $milestone = get_field('milestone');
@endphp

<div id="{{ $block_info['id'] }}"
     class="{{ $block_info['classes'] }} timeline">

    <div class="swiper-container milestone">
        <div class="arrow-container">
            <div class="swiper-button-prev">
              @svg('images/arrow-left.svg')
            </div>
        </div>
        <div class="swiper-wrapper">
            @foreach($milestone as $key => $step)
            @php
                $title = $step['title'];
                $description = $step['description'];
            @endphp
                <div class="swiper-slide">
                    <div class="single">
                        <h2>{!! $title !!}</h2>
                        <div>{!! $description !!}</div>
                    </div>
                </div>
            @endforeach
        </div>
        <div class="arrow-container">
            <div class="swiper-button-next">
              @svg('images/arrow-right.svg')
            </div>
        </div>
    </div>
     <div class="custom-pagination swiper-container">
        <div class="container wrapper swiper-wrapper">
            @foreach($milestone as $key => $step)
            <div data-index="{!! $key !!}" class="pagination swiper-slide">
                @php
                    $label = $step['label'];
                @endphp
                <div class="external-circle">
                    <div class="circle"></div>
                </div>
                <div class="label">{!! $label !!}</div>
            </div>
            @endforeach
        </div>
    </div>
</div>
