@php
  $description = get_field('description');
  $title_extended = get_field('title_extended');

  $gallery = get_field('gallery');

  $specifications = get_field('specifications');
  $characteristics = get_field('characteristics');
  $applications = get_field('applications');

  $finitures = get_field('finitures');
  $tints = get_field('tints');
  $properties = get_field('properties');

  $sheet = get_field('sheet');
  $sheet_download = get_field('link', $sheet[0]->ID);
  $sheet_description = get_field('description', $sheet[0]->ID);
@endphp

<article {!! post_class('single-product') !!}>
  <div class="container">
    @include('partials/page-header', ['is_product' => true, 
                                       'title_extended' => $title_extended,
                                       'description' => $description])

    <div class="post-content-wrapper">
      <div class="gallery">
        <div class="grid-list four">
            @if($gallery)
              @foreach($gallery as $image)
                  <div class="w-full">
                      <figure class="bg-transparent">
                          <img class="object-contain" src="{!! $image['url'] !!}"/>
                      </figure>
                  </div>
              @endforeach
            @endif
        </div>
      </div>
      <div class="cheat-sheet">
          @include('partials.product.product-sheet', ['title' => __('Technical information','thor'), 'content' => $specifications])
          @include('partials.product.product-sheet', ['title' => __('Applications','thor'), 'content' => $applications])
          @include('partials.product.product-sheet', ['title' => __('Features','thor'), 'content' => $characteristics])
          @include('partials.product.product-sheet-grid', ['title' => __('Finitures','thor'), 'content' => $finitures, 'overlay' => true])
          @include('partials.product.product-sheet-grid', ['title' => __('Tints','thor'), 'content' => $tints,'overlay' => true])
          @include('partials.product.product-sheet-grid', ['title' => __('Properties','thor'), 'content' => $properties, 'overlay' => false])

          @if($sheet)
            <div class="single-sheet download">
                <div class="title">
                    <h6>
                        {!! __('Download','thor') !!}
                    </h6>
                </div>
                <a 
                href="{!! $sheet_download['url'] !!}"
                target="{!! $sheet_download['target'] !!}"
                title="{!! $sheet_download['title'] !!}"
                class="content download">
                    <div>
                        {!! $sheet_description !!}
                    </div>
                    <div>
                        @svg('images/arrow-down.svg')
                    </div>
                </a>
            </div>
          @endif
      </div>
    </div>
  </div>
  @include('partials.product.product-related')
</article>
