@extends('layouts.app')

@section('content')
  <div class="container">
    @php
      $description = get_field('archive_decor_subtitle','option');
    @endphp
    @include('partials.page-header', ['is_archive' => true, 'description' => $description])
    @include('partials.filter-buttons', ['taxonomy' => 'decors-category', 'post_type' => 'decor', 'only_parents' => true])

    <div class="flex flex-col list">
      @if (!have_posts())
      @else
        <div class="inner-list">
          <div class="decors-container" data-load-more data-default="grid-small">
            @php
              global $post;
              global $wp_query;
            @endphp
            @while (have_posts()) @php the_post() @endphp
                <div class="w-full">
                  @include('partials.teaser-'.get_post_type(), ['show_highlight_label' => true])
                </div>
            @endwhile
          </div>
        </div>
      @endif
      @include('partials.decor.decor-single-panel')
      @include('partials.decor.decor-single-filter')
    </div>
    @include('partials.utils.infinite-loader')


    @if(function_exists('wp_pagenavi'))
      {!!  wp_pagenavi(); !!}
    @endif

  </div>
@endsection
