@php
  $block_info = App::get_block_info($block);
  $taxonomies = App::get_decor_taxonomies();
  $decors_selection = get_field('decors_selection');
  
@endphp

@if($decors_selection && count($decors_selection) > 0)
    <div id="{{ $block_info['id'] }}"
        class="{{ $block_info['classes'] }} decor-list {!! $layout !!}">

        @foreach($decors_selection as $post)
            @php
                setup_postdata($post);

                $tints = get_post_meta($post->ID, '_tinte', true);
                $taxonomies = App::get_decor_taxonomies();

                if(!is_array($tints)) {
                    $tints = json_decode($meta, true);
                }

                $code = get_post_meta($post->ID, '_codice', true);
    
                if (!$code) {
                    $code = get_post_meta($post->ID, '_codice_temporaneo', true);
                }
            @endphp

            <article {!! post_class('decor-single') !!}>
                <div>
                    <div class="page-header">
                        <div class="title">
                            <h1 class="mb-4 page-title">
                                {!! get_the_title($post) !!} {{ $code ? $code : '' }}
                            </h1>
                        </div>
                    </div>

                    @include('partials.decor.decor-development', ['tints' => $tints, 'post' => $post])
                    @include('partials.decor.decor-gallery', ['tints' => $tints])
                    @include('partials.decor.decor-gallery-flooring', ['tints' => $tints])
                    <div class="info">
                        @include('partials.decor.decor-preview', ['tints' => $tints])
                        <div class="content">
                            @include('partials.decor.decor-sheet', ['tints' => $tints, 'taxonomies' => $taxonomies, 'post' => $post])
                            @include('partials.decor.decor-inuse', ['tints' => $tints])
                            @include('partials.decor.decor-inuse-flooring', ['tints' => $tints])
                            @include('partials.decor.decor-additional', ['tints' => $tints])
                        </div>
                    </div>
                </div>
            </article>
        @endforeach
    </div>

    @php
        wp_reset_postdata();
    @endphp
@endif
