@php
  $block_info = App::get_block_info($block);

  $filter = get_field('filter');
  $how_much = get_field('how_much');
  $teaser = get_field('teaser');
  $columns = get_field('columns');

  $args = array(
      'post_type' => 'downloads',
      'numberposts' => $how_much,
  );

  switch ($filter) {
      case 'last':
            $posts = get_posts($args);
          break;

      case 'taxonomy':
            $taxonomy = get_field('taxonomy');
            $args['tax_query'][] = 
                [
                    'taxonomy' => 'downloads-category',
                    'terms' => $taxonomy,
                ];

            $posts = get_posts($args);
          break;

      case 'specific':
            $posts = get_field('specific');
          break; 

      default:
        break;
  }

@endphp

<div id="{{ $block_info['id'] }}"
     class="{{ $block_info['classes'] }} downloads-list">
     <div class="hidden gap-8 lg:gap-0 lg:gap-8 lg:grid-cols-4 lg:grid-cols-3 lg:grid-cols-2 lg:grid-cols-1"></div>

    <div class="@if($teaser == 'image') gap-4 md:gap-8 grid-cols-2 @else gap-0 md:gap-x-8 grid-cols-1 md:grid-cols-2 @endif grid {{ $columns }}">
        @php
            global $post;
        @endphp
        @foreach($posts as $key => $post)
            <div>
                @include('partials.teaser-' . get_post_type($post), ['type' => $teaser, 'post' => $post])
            </div>
        @endforeach
    </div>
</div>
