@php
    $block_info = App::get_block_info($block);
    $style = get_field('style') ? get_field('style') : 'is-style-light';
    $poster = get_field('poster');
    $autoplay = get_field('autoplay') ? 'autoplay' : '';
    $loop = get_field('loop') ? 'loop' : '';
    $muted = get_field('muted') ? 'muted' : '';
    $url = get_field('url');

    $autoplay_type = get_field('autoplay_type');
@endphp

<div id="{{ $block_info['id'] }}"
     class="{{ $block_info['classes'] }} video-player-embed">
    <div class="video-player {!! $style !!}">
        <video 
            poster="{!! $poster['url'] !!}"
            data-autoplay="{!! $autoplay_type !!}"
            controls
            playsinline
            {!! $loop !!}
            {!! $autoplay !!}
            {!! $muted !!}
            class="custom-video vjs-has-started video-js">
            <source src="{!! $url !!}">
        </video>
    </div>
</div>