import Swiper from 'swiper';
import SwiperCore, { Navigation, Pagination } from 'swiper/core';

SwiperCore.use([Navigation, Pagination]);

export default (() => {
    const focus = new Swiper('.swiper-focus.swiper-container', {
        loop: false,
        spaceBetween: 32,
        draggable: false,
        allowTouchMove: false,
        simulateTouch: false,
        breakpoints: {
            480: {
                slidesPerView: 1,
                spaceBetween: 16,
            },
            768: {
                slidesPerView: 2,
                spaceBetween: 24,
            },
            1024: {
                slidesPerView: 4,
                spaceBetween: 32,
            },
        },
        navigation: {
            nextEl: '.arrow-container .swiper-button-next',
            prevEl: '.arrow-container .swiper-button-prev',
        },
    });
})()