@php
    $title = $title ? $title : '';
    $description = $description ? $description : '';
    $link = $link ? $link : '';
    $link_title = $link_title ? $link_title : __('Find out more', 'thor');
    $target = $target ? $target : '_self';
@endphp

<a 
  class="is-card-layout"
  href="{!! $link !!}"
  target="{!! $target !!}">
    @if($image)
        <figure>
            <img 
                class="lazy"
                src="{!! $image !!}"
                data-src="{!! $image_lazy !!}"
                @if($image_title) title="{!! $image_title !!}" @endif>
        </figure>
    @endif
    @if($title)
        <h2>{!! $title !!}</h2>
    @endif
    @if($description)
        <div>{!! $description !!}</div>
    @endif
    @if($show_button)
        <button class="mt-4 text-xs button arrow light">
            {!! $link_title !!}
            @svg('images/arrow-right.svg')
        </button>
    @endif
</a>