@php
    $intro_text = get_field('intro_text');
    $text_render_1 = get_field('text_render_1');
    $text_render_2 = get_field('text_render_2');
    $text_render_3 = get_field('text_render_3');

    // interactive or simplified
    $inspiration_creation_mode = get_field('inspiration_creation_mode');

    // true or false
    $is_interactive = $inspiration_creation_mode == 'interactive';
    $is_simplified = $inspiration_creation_mode == 'simplified';
@endphp


<article {!! post_class('single-inspiration') !!}>
  <div class="container">
    @include('partials/page-header', ['is_single' => true])
    <div class="post-content-wrapper">
        @if($is_interactive)
            @include('partials.inspiration.inspiration-interactive-mode')
        @elseif($is_simplified)
            @include('partials.inspiration.inspiration-simplified-mode')
        @else
            @include('partials.inspiration.inspiration-interactive-mode')
        @endif
    </div>
  </div>
  @include('partials.inspiration.inspiration-focus')
</article>
