export default (() => {
  const persons = document.querySelectorAll('.person')

  persons.forEach(element => {
    const data = element.querySelector('.data')

    if(data) {
        const title = data.dataset.title
        const subtitle = data.dataset.subtitle
        const description = data.dataset.description
        const toBeParsedlinks = data.dataset.links
        const links = JSON.parse(toBeParsedlinks)


        data.addEventListener('click', () => {
            createPopup ()
        })



        function createPopup() {
            const close = document.createElement('div')
            close.classList.add('close')

            const popup = document.createElement('div')
            popup.classList.add('person_modal')

            const inner = document.createElement('div')
            inner.classList.add('inner')

            const titleEl = document.createElement('h3')
            titleEl.classList.add('title')
            titleEl.textContent = title

            const subtitleEl = document.createElement('h3')
            subtitleEl.classList.add('subtitle')
            subtitleEl.textContent = subtitle

            const descriptionEl = document.createElement('div')
            descriptionEl.classList.add('description')
            descriptionEl.innerHTML = description

            const linksEl = document.createElement('div')
            linksEl.classList.add('links')

            if(links) {
                links.forEach(single => {
                    const linkEl = document.createElement('a')
                    linkEl.setAttribute('href', single.link.url)
                    linkEl.setAttribute('target', '_blank')
                    linkEl.textContent = single.link.title
                    linksEl.appendChild(linkEl)
                })
            }

            inner.appendChild(close)
            inner.appendChild(titleEl)
            inner.appendChild(subtitleEl)
            inner.appendChild(linksEl)
            inner.appendChild(descriptionEl)

            popup.appendChild(inner)

            close.addEventListener('click', () => {
                popup.classList.remove('active')
                setTimeout(() => {
                    element.removeChild(popup)
                }, 300);
            })

            element.appendChild(popup)
            setTimeout(() => {
            
                popup.classList.add('active')
            }, 1);
        }
    }
  });
})()