@php
  if ($is_category) {
      $terms = get_categories($args);
      $args = [
          'hide_empty' => false,
      ];
  } else {
      $args = [
          'hide_empty' => false,
          'taxonomy' => $taxonomy,
      ];

      $terms = get_terms($args);
  }

  $current = get_queried_object()->slug;
  $archive_link_active = true;

  if ($only_parents):
      $terms = array_filter($terms, function ($term) {
          return !$term->parent ? $term : null;
      });
  endif;

  $exclude_children_in_menu = get_field('exclude_children_in_menu', get_queried_object());

  if ($only_queried_children):
      $current = get_queried_object()->term_id;
      $ancestor = end(get_ancestors($current, 'decors-category', 'taxonomy'));

      $terms = array_filter($terms, function ($term) use ($current, $ancestor) {
          if ($ancestor && $ancestor == $term->parent) {
              return $term;
          }

          if ($term->parent == $current) {
              return $term;
          }
      });

      $archive_link_active = false;
  endif;

  foreach ($terms as $term):
      if ($current == $term->slug):
          $archive_link_active = false;
      endif;
  endforeach;

  $currently_queried = App::get_current_queried();
@endphp
<div class="button-wrapper">
  <a class="button outlined @if ($archive_link_active) disabled @endif" href="{!! get_post_type_archive_link($post_type) !!}">
    {!! __('See all', 'thor') !!}
  </a>
  @if (!$exclude_children_in_menu)
    @foreach ($terms as $key => $term)
      @php
        $link = App::get_category_link_with_arg($term, $currently_queried, $post_type);
        $active = get_queried_object()->slug;
      @endphp
      <a href="{{ $link }}" class="button outlined @if ($active == $term->slug) disabled @endif">
        {!! $term->name !!}
      </a>
    @endforeach
  @endif
</div>
