@php
    $additional_field_name = get_field('additional_field_name') ?: '';
    $additional_field_decor = get_field('additional_field_decor');
    $name_a = get_field('name_a') ?: '';
    $name_b = get_field('name_b') ?: '';
    $name_c = get_field('name_c') ?: '';

    $filters = [
        $name_a => ['f1', 'f2'],

        $name_b => ['k1', 'k2'],

        $name_c => ['t1', 't2'],

        $additional_field_name => ['additional_field_decor'],
    ];

    // Decors
    $simple_decor_1 = get_field('simple_decor_1');
    $simple_decor_2 = get_field('simple_decor_2');
    $simple_decor_3 = get_field('simple_decor_3');
    $simple_decor_4 = get_field('simple_decor_4');

    // Decor titles
    $simple_decor_title_1 = get_field('simple_decor_title_1');
    $simple_decor_title_2 = get_field('simple_decor_title_2');
    $simple_decor_title_3 = get_field('simple_decor_title_3');
    $simple_decor_title_4 = get_field('simple_decor_title_4');

    // Decor code
    $simple_code_1 = get_field('simple_code_1');
    $simple_code_2 = get_field('simple_code_2');
    $simple_code_3 = get_field('simple_code_3');
    $simple_code_4 = get_field('simple_code_4');
@endphp


<div class="focus">
    <h2>
        {!! __('Focus on', 'thor') !!}
    </h2>
    @if ($is_interactive)
        @foreach ($filters as $key => $filter)
            <div class="container">
                @if ($key)
                    <h3>
                        {!! $key !!}
                    </h3>
                @endif

                @php
                    $posts = App::get_decors_filter_by_name($filter);
                @endphp

                <div class="inner">
                    @foreach ($posts as $key => $post)
                        @if ($post[0])
                            @php
                                $tint_code = get_field('tint_code_' . $key);

                                if (!$tint_code) {
                                    $tint_code = get_field('additional_tint_code');
                                }

                                $decor_code = get_post_meta($post[0]->ID, '_codice', true);
                                $get_tint = App::get_tint_by_code($tint_code, $post[0]->ID);
                            @endphp
                            <article {{ post_class('teaser teaser-decor') }}>
                                <a href="{!! get_permalink($post[0]) !!}" class="single">
                                    <figure>
                                        @if (!$get_tint)
                                            <img class="lazy" src="{!! get_the_post_thumbnail_url($post[0]->ID, 'medium') !!}"
                                                data-src="{!! get_the_post_thumbnail_url($post[0]->ID, 'large') !!}" />
                                        @else
                                            <img src="{!! wp_get_attachment_url($get_tint['_immagine_di_anteprima_media_id']) !!}" />
                                        @endif
                                    </figure>
                                    <header>
                                        <p>{{ $post[0]->post_title }}</p>
                                    </header>
                                </a>
                            </article>
                        @endif
                    @endforeach
                </div>
            </div>
        @endforeach
    @endif

    @if ($is_simplified)
    @endif

    @if ($is_simplified)
        {{-- Focus section --}}
        <div class="container is-simplified">
            <div class="swiper-focus swiper-container">
                <div class="arrow-container">
                    <div class="swiper-button-prev">
                        @svg('images/arrow-left.svg')
                    </div>
                    <div class="swiper-button-next">
                        @svg('images/arrow-right.svg')
                    </div>
                </div>
                <div class="swiper-wrapper">
                    @for ($i = 1; $i <= 4; $i++)
                        <div class="{{ 'decor-content-' . $i }} swiper-slide">
                            @php
                                $decor_id = ${'simple_decor_' . $i}[0]->ID;
                            @endphp
                            @if (${'simple_decor_title_' . $i})
                                <div class="decor-title-content">
                                    <h3>{!! ${'simple_decor_title_' . $i} !!}</h3>
                                </div>
                            @endif
                            @if (${'simple_decor_' . $i})
                                <figure>
                                    <img src="{!! get_the_post_thumbnail_url($decor_id, 'medium') !!}" alt="{!! ${'simple_decor_' . $i}['alt'] !!}">
                                </figure>
                            @endif
                            @if (${'simple_code_' . $i})
                                <div class="decor-code-content">
                                    <p>{!! ${'simple_code_' . $i} !!}</p>
                                </div>
                            @endif
                        </div>
                    @endfor
                </div>
            </div>
        </div>
    @endif
</div>
