<?php
/**
 * The template for displaying Archive pages.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @author Dueper Design
 * @package Dueper Theme
 */

// creao redirect alla research-area in questa categoria
$cat = get_query_var('cat');
$args_area = array(
    'post_type'     => 'research_area',
    'posts_per_page'=> 1,
    'cat'           => $cat
);
$areas = new WP_query($args_area);
if($areas->have_posts()):
  while( $areas->have_posts()) : $areas->the_post();
    $thumb = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'slide' );
    $url = $thumb['0'];
  endwhile;
endif;
wp_reset_query();

get_header(); 
    if(have_posts()):?>
        <div class="page-title" style="background-image:url(<?php echo $url; ?>);">
          <h5><?php _e('News'); ?></h5>
          <h3><?php single_cat_title(); ?></h3>
        </div>
        <div class="container">            
            <div class="row">
                <div class="col-md-8 main-page-content">
                    <div class="row">
                        <?php while(have_posts()): the_post(); ?>
                            <div class="col-sm-6">
                                <article <?php post_class('intro-fade equalheight'); ?>>
                                    <figure>
                                        <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                                            <?php the_post_thumbnail('post-img',array('class'=>'img-responsive')); ?>
                                        </a>
                                    </figure>
                                    <div class="content">
                                        <?php the_category(); ?>
                                        <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                                            <h3><?php the_title(); ?></h3>
                                        </a>
                                        <div>
                                        <?php the_excerpt(); ?>
                                        </div>
                                    </div><!--content-->
                                </article><!--post-class-->
                            </div><!--col-sm-6-->
                        <?php endwhile; ?>
                    </div><!--row-->

                    <?php if (function_exists('wp_pagenavi')) wp_pagenavi(); ?>

                </div><!--col-md-8-->
                <div class="col-md-4">
                  <?php get_sidebar(); ?>
                </div>
            </div><!--row-->
        </div><!--container-->
<?php endif; ?>
<?php get_footer(); ?>