<?php
/**
 * The template for displaying Archive pages.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @author Dueper Design
 * @package Dueper Theme
 */

get_header(); ?>
	<div class="container">
		<div class="row">
			<div class="col-md-12">
			
					<?php if ( have_posts() ) : ?>
			
						<header class="page-header">
							<h1 class="page-title">
								<?php
									if ( is_category() ) :
										single_cat_title();
			
									elseif ( is_tag() ) :
										single_tag_title();
			
									elseif ( is_author() ) :
										/* Queue the first post, that way we know
										 * what author we're dealing with (if that is the case).
										*/
										the_post();
										printf( __( 'Author: %s', 'upbootwp' ), '<span class="vcard">' . get_the_author() . '</span>' );
										/* Since we called the_post() above, we need to
										 * rewind the loop back to the beginning that way
										 * we can run the loop properly, in full.
										 */
										rewind_posts();
			
									elseif ( is_day() ) :
										printf( __( 'Day: %s', 'upbootwp' ), '<span>' . get_the_date() . '</span>' );
			
									elseif ( is_month() ) :
										printf( __( 'Month: %s', 'upbootwp' ), '<span>' . get_the_date( 'F Y' ) . '</span>' );
			
									elseif ( is_year() ) :
										printf( __( 'Year: %s', 'upbootwp' ), '<span>' . get_the_date( 'Y' ) . '</span>' );
			
									elseif ( is_tax( 'post_format', 'post-format-aside' ) ) :
										_e( 'Asides', 'upbootwp' );
			
									elseif ( is_tax( 'post_format', 'post-format-image' ) ) :
										_e( 'Images', 'upbootwp');
			
									elseif ( is_tax( 'post_format', 'post-format-video' ) ) :
										_e( 'Videos', 'upbootwp' );
			
									elseif ( is_tax( 'post_format', 'post-format-quote' ) ) :
										_e( 'Quotes', 'upbootwp' );
			
									elseif ( is_tax( 'post_format', 'post-format-link' ) ) :
										_e( 'Links', 'upbootwp' );
			
									else :
										_e( 'Archives', 'upbootwp' );
			
									endif;
								?>
							</h1>
						</header><!-- .page-header -->
			
						<?php while ( have_posts() ) : the_post(); ?>
							<?php $categories = get_the_category();
							if($categories):
								foreach($categories as $category):
									$cat_id = $category->term_id;
									$cat_name = $category->name;
								endforeach;
							endif;?>
							<div <?php post_class('row single-content-news'); ?>>
                                <div class="content-image">
                                    <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                                        <?php the_post_thumbnail('large',array('class'=>'img-responsive')); ?>
                                    </a>
                                    
                                    <?php $bg_color = get_field('bg_color','category_'.$cat_id);
                                    $icon = get_field('icona','category_'.$cat_id); ?>
                                    <div class="category-label" <?php if($bg_color): ?> style="background:<?php echo $bg_color; ?>;" <?php endif; ?>>
                                        <span class="glyphicon <?php echo $icon; ?>"></span> <?php echo $cat_name; ?>
                                    </div>
                                    
                                </div><!--content-image-->
                                <div class="content-text">
                                    <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                                        <h5><?php the_title(); ?></h5>
                                    </a>
                                    <?php $date = get_the_date(); ?>
                                    <small><?php the_excerpt(); ?></small>
                                    <small><?php echo $date; ?></small>
                                    
                                </div><!-- Content image -->
                        	</div><!--row-->
						<?php endwhile; ?>
			
					<?php endif; ?>
					
			</div><!-- .col-md-12 -->
		</div><!-- .row -->
	</div><!-- .container -->
<?php get_footer(); ?>
