<?php
/**
 * The template for displaying Archive pages.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @author Dueper Design
 * @package Dueper Theme
 */

$author = get_user_by( 'slug', get_query_var( 'author_name' ) );
$author_ID = $author->ID;
$acf_user = "user_".$author_ID;
get_header(); ?>

  <div class="container">
    <div class="row">
      <div class="col-xs-12 col-sm-12 col-md-10 col-xs-offset-0 col-sm-offset-0 col-md-offset-1 toppad" >
        <div class="row">
          <div class="col-md-2 col-sm-3 author" align="center">
            <div class="avatarc">
				<?php echo get_avatar( $author_ID , 100 ); ?>
			</div>
		  <!--<img alt="User Pic" src="https://lh5.googleusercontent.com/-b0-k99FZlyE/AAAAAAAAAAI/AAAAAAAAAAA/eu7opA4byxI/photo.jpg?sz=100" class="img-circle">
		  -->
          </div>

          <!--<div class="col-xs-10 col-sm-10 hidden-md hidden-lg"> <br>
            <dl>
              <dt>DEPARTMENT:</dt>
              <dd>Administrator</dd>
              <dt>HIRE DATE</dt>
              <dd>11/12/2013</dd>
              <dt>DATE OF BIRTH</dt>
                 <dd>11/12/2013</dd>
              <dt>GENDER</dt>
              <dd>Male</dd>
            </dl>
          </div>-->
          <div class="col-md-10 col-sm-9 ">
            <!-- NAME -->
            <h3><?php echo $author->first_name.' '.$author->last_name; ?></h3>
            
            <!-- BASIC INFO -->
             <table class="table table-user-information">
              <tbody>
                <?php if(get_field('university', $acf_user)): ?>
                  <tr>
                    <td class="title"><strong><?php _e('University'); ?></strong></td>
                    <td><?php $variable = the_field('university', $acf_user); ?></td>
                  </tr>
                <?php endif; ?>
				
                <?php if(get_field('department', $acf_user)): ?>
                  <tr>
                    <td class="title"><strong><?php _e('Department'); ?></strong></td>
                    <td><?php $variable = the_field('department', $acf_user); ?></td>
                  </tr>
                <?php endif; ?>

                <?php if($author->user_description): ?>
                  <tr>
                    <td class="title"><strong><?php _e('Biographical Info'); ?></strong></td>
                    <td><?php echo $author->user_description; ?></td>
                  </tr>
                <?php endif; ?>

                <?php if($author->user_email): ?>
                  <tr>
                    <td class="title"><strong><?php _e('Email'); ?></strong></td>
                    <td><a href="mailto:<?php echo $author->user_email; ?>"><?php echo $author->user_email; ?></a></td>
                  </tr>
                <?php endif; ?>

                <?php if($author->user_url): ?>
                  <tr>
                    <td class="title"><strong><?php _e('Website'); ?></strong></td>
                    <td><a href="<?php echo $author->user_url; ?>" target="_blank"><?php echo $author->user_url; ?></a></td>
                  </tr>
                <?php endif; ?>
				
                <?php if(get_field('publications_website', $acf_user)): ?>
                  <tr>
                    <td class="title"><strong><?php _e('Publications'); ?></strong></td>
                    <td><?php $variable = the_field('publications_website', $acf_user); ?></td>
                  </tr>
                <?php endif; ?>

                <?php if(get_field('phone_number', $acf_user) && is_user_logged_in()): ?>
                  <tr>
                    <td class="title"><strong><?php _e('Phone Number'); ?></strong></td>
                    <td>
                      <?php the_field('phone_number', $acf_user); ?>
                    </td>
                  </tr>
                <?php endif; ?>
               </tbody>
            </table>

            <!-- MORE INFO -->
            <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
              <div class="panel panel-default">
                <div class="panel-heading" role="tab" id="headingOne">
                  <h4 class="panel-title">
                    <a data-toggle="collapse" href="#author-info" aria-expanded="true" aria-controls="author-info">
                      <small>&#x25BC;</small> <?php _e('View more info'); ?>
                    </a>
                  </h4>
                </div>
                
                <div class="collapse more-author-info" id="author-info">
                  <!--table for members-->
                  <table class="table table-user-information">
                    <tbody>
                      
					<?php
					// $terms = get_terms( 'keyword', array( 'hide_empty' => true ) );
					// $keywords = array();
					// if ( !empty( $terms ) ) {
						// foreach ( $terms as $term ) { 
							// if(is_object_in_term( $author_ID, 'keyword', $term ))
								// array_push($keywords, $term );
						// }
					// }
					$keywords = get_author_keywords($author_ID, false);
					  if($keywords): ?>
                        <tr>
                          <td><strong><?php _e('Keywords'); ?></strong></td>
                          <td>
                            <ul class="list-inline">
							<?php // echo json_encode($keywords);?>
                              <?php foreach($keywords as $keyword):
								$term_link = get_term_link( $keyword->slug, 'post_tag' );
								if ( is_wp_error( $term_link ) ) continue;
								?>
								<li><a href="<?php echo $term_link; ?>" class="label label-primary"><?php echo $keyword->name; ?></a></li>
                              <?php endforeach; ?>
                            </ul>
                          </td>
                        </tr>
                      <?php endif; ?>

                      <?php
                      $areas = get_field('reasearch_areas',$acf_user);
                      if(!empty($areas)): ?>
                        <tr>
                          <td><strong><?php _e('Research Areas'); ?></strong></td>
                          <td>
                            <ul class="list-inline">
                              <?php foreach($areas as $area):
                                echo '<li><a href="'.get_permalink($area->ID).'" class="label label-primary">'.$area->post_title.'</a></li>';
                              endforeach; ?>
                            </ul>
                          </td>
                        </tr>
                      <?php endif; ?>

                      <?php if(get_field('laboratories', $acf_user)): ?>
                        <tr>
                          <td><strong><?php _e('Laboratories'); ?></strong></td>
                          <td>
                            <?php the_field('laboratories', $acf_user); ?>
                          </td>
                        </tr>
                      <?php endif; ?>

                      <?php if(get_field('research_fields', $acf_user)): ?>
                        <tr>
                          <td><strong><?php _e('Research fields'); ?></strong></td>
                          <td>
                            <?php the_field('research_fields', $acf_user); ?>
                          </td>
                        </tr>
                      <?php endif; ?>

                      <?php if(get_field('techniques_mastered', $acf_user) && is_user_logged_in()): ?>
                        <tr>
                          <td><strong><?php _e('Techniques mastered'); ?></strong></td>
                          <td>
                            <?php the_field('techniques_mastered', $acf_user); ?>
                          </td>
                        </tr>
                      <?php endif; ?>

                      <?php if(get_field('facilities', $acf_user) && is_user_logged_in()): ?>
                        <tr>
                          <td><strong><?php _e('Facilities available to the person'); ?></strong></td>
                          <td>
                            <?php the_field('facilities', $acf_user); ?>
                          </td>
                        </tr>
                      <?php endif; ?>

                      <?php if(get_field('external_collaborations', $acf_user) && is_user_logged_in()): ?>
                        <tr>
                          <td><strong><?php _e('External collaborations'); ?></strong></td>
                          <td>
                            <?php the_field('external_collaborations', $acf_user); ?>
                          </td>
                        </tr>
                      <?php endif; ?>

                    </tbody>
                  </table>
                </div><!--collapse-->
              </div><!--panel-->
            </div><!--panle-group-->
            
          </div>
        </div>
      </div>
    </div><!--row-->
    <hr>
    <div class="row">
      <?php if(is_user_logged_in()): ?>
      
        <?php
          $project_args = array(
            'post_type'     => 'project',
            'author'        => $author_ID,
            'posts_per_page'=> -1
          );
          $projects = new WP_Query($project_args);
          if($projects->have_posts()):
            echo '<div class="col-md-3">';
            echo '<h3>'.__('Projects by: ').$author->first_name.' '.$author->last_name.'</h3>';
            echo '<ul class="">';
              while($projects->have_posts()): $projects->the_post();
                echo '<li><a href="'.get_permalink().'" title="'.get_the_title().'">'.get_the_title().'</a></li>';
              endwhile;
            echo '</ul>';
            echo '</div>';
          endif;
        ?>
      
        <?php
        $project_args = array(
          'post_type'     => 'question',
          'author'        => $author_ID,
          'posts_per_page'=> -1
        );
        $projects = new WP_Query($project_args);
        if($projects->have_posts()):
          echo '<div class="col-md-3">';
          echo '<h4>'.__('Question by: ').$author->first_name.' '.$author->last_name.'</h4>';
          echo '<ul class="">';
            while($projects->have_posts()): $projects->the_post();
              echo '<li><a href="'.get_permalink().'" title="'.get_the_title().'">'.get_the_title().'</a></li>';
            endwhile;
          echo '</ul>';
          echo '</div>';
        endif;
        ?>
      
        <?php
        $project_args = array(
          'post_type'     => 'journal_club_entry',
          'author'        => $author_ID,
          'posts_per_page'=> -1
        );
        $projects = new WP_Query($project_args);
        if($projects->have_posts()):
          echo '<div class="col-md-3">';
          echo '<h4>'.__('Journal Club Entries by: ').$author->first_name.' '.$author->last_name.'</h4>';
          echo '<ul class="">';
            while($projects->have_posts()): $projects->the_post();
              echo '<li><a href="'.get_permalink().'" title="'.get_the_title().'">'.get_the_title().'</a></li>';
            endwhile;
          echo '</ul>';
          echo '</div>';
        endif; ?>
      
        <?php
        $project_args = array(
          'post_type'     => 'news',
          'author'        => $author_ID,
          'posts_per_page'=> -1
        );
        $projects = new WP_Query($project_args);
        if($projects->have_posts()):
          echo '<div class="col-md-3">';
          echo '<h4>'.__('News by: ').$author->first_name.' '.$author->last_name.'</h4>';
          echo '<ul class="">';
            while($projects->have_posts()): $projects->the_post();
              echo '<li><a href="'.get_permalink().'" title="'.get_the_title().'">'.get_the_title().'</a></li>';
            endwhile;
          echo '</ul>';
          echo '</div>';
        endif; ?>
      
      <?php else : // if user is not logged in ?>
        
        <?php
          $project_args = array(
            'post_type'     => 'news',
            'author'        => $author_ID,
            'posts_per_page'=> -1
          );
          $projects = new WP_Query($project_args);
          if($projects->have_posts()):
            echo '<div class="col-md-6">';
            echo '<h4>'.__('News by: ').$author->first_name.' '.$author->last_name.'</h4>';
            echo '<ul class="">';
              while($projects->have_posts()): $projects->the_post();
                echo '<li><a href="'.get_permalink().'" title="'.get_the_title().'">'.get_the_title().'</a></li>';
              endwhile;
            echo '</ul>';
            echo '</div>';
          endif; ?>
      
      <?php endif; //if user is not logged in?>
    </div><!--row-->
  </div>

<?php get_footer(); ?>
