<?php
/**
 * The template for displaying Archive pages.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @author Dueper Design
 * @package Dueper Theme
 */

// creao redirect alla research-area in questa categoria
$cat = get_query_var('cat');
$args_redirect = array(
    'post_type'     => 'research_area',
    'posts_per_page'=> -1,
    'cat'           => $cat
);
$areas = new WP_query($args_redirect);
if($areas->have_posts()):
    while($areas->have_posts()): $areas->the_post();
        wp_redirect(get_permalink());
    endwhile;
// Se non ne esistono mostro le news di questa categoria
  wp_reset_query();
else :
    get_header(); 
        if(have_posts()):?>
            <header class="page-title">
              <h1><?php single_cat_title(); ?></h1>
            </header>
            <div class="container main-page-content">
                <div class="row">
                    <div class="col-md-8">
                        <div class="row">
                            <?php while(have_posts()): the_post(); ?>
                                <div class="col-sm-6">
                                    <article <?php post_class('intro-fade equalheight'); ?>>
                                        <figure>
                                            <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                                                <?php the_post_thumbnail('post-img',array('class'=>'img-responsive')); ?>
                                            </a>
                                        </figure>
                                        <div class="content">
                                            <?php the_category(); ?>
                                            <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                                                <h3><?php the_title(); ?></h3>
                                            </a>
                                            <div>
                                            <?php the_excerpt(); ?>
                                            </div>
                                            <date><?php echo get_the_date(); ?></date>
                                        </div><!--content-->
                                    </article><!--post-class-->
                                </div><!--col-sm-6-->
                            <?php endwhile; ?>
                        </div><!--row-->

                        <?php if (function_exists('wp_pagenavi')) wp_pagenavi(); ?>

                    </div><!--col-md-8-->
                </div><!--row-->
            </div><!--container-->
    <?php else:  ?>
        
      NON CI SONO POST
    <?php endif; ?>
    <?php get_footer(); ?>
<?php endif; ?>