<?php
/**
 *
 * @author Dueper Design
 * @package Dueper Theme
 */

if (!isset($content_width)) $content_width = 770;

/**
 * upbootwp_setup function.
 * 
 * @access public
 * @return void
 */
function upbootwp_setup() {

	require 'inc/general/class-Upbootwp_Walker_Nav_Menu.php';
    require 'inc/general/class-Mobile_Walker_Nav_Menu.php';
    require 'functions/comments-layout.php';
    require 'admin/admin.php';

	load_theme_textdomain('upbootwp', get_template_directory().'/languages');

	add_theme_support( 'automatic-feed-links' );

	/**
	 * Enable support for Post Thumbnails on posts and pages
	 *
	 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
	 */
	//add_theme_support( 'post-thumbnails' );

	register_nav_menus( array(
		'primary' => __( 'Primary Menu for Anonymous', 'Bootstrap WP Primary' ),
		'primary-member' => __( 'Primary Menu for Members', 'Bootstrap WP Primary' ),
        'top' => __( 'Top', 'Bootstrap WP Primary' ),
	) );

	/**
	 * Enable support for Post Formats
	 */
	//add_theme_support( 'post-formats', array( 'aside', 'image', 'video', 'quote', 'link' ) );

	/**
	 * Setup the WordPress core custom background feature.
	 */
	/*add_theme_support( 'custom-background', apply_filters( 'upbootwp_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	)));*/
	
	
}

add_action( 'after_setup_theme', 'upbootwp_setup' );


/**
 * Creo le dimensioni per le varie thumbnail
 */
if ( function_exists( 'add_theme_support' ) ) {
  add_theme_support( 'post-thumbnails' );
  set_post_thumbnail_size( 160, 120 ); // 160 pixels wide by 120 pixels high
}
if ( function_exists( 'add_image_size' ) ) {
  add_image_size( 'post-img', 400, 200, true );
  add_image_size( 'people-img', 300, 300, true );
  add_image_size( 'slide', 1920, 500, true );
  add_image_size( 'share', 600, 315, true );
  add_image_size( 'maps', 640, 515, true );
}


/**
 * Register widgetized area and update sidebar with default widgets
 */
function upbootwp_widgets_init() {
	
    register_sidebar(array(
		'name'          => __('Azienda','upbootwp'),
		'id'            => 'azienda',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4>',
	));
    
    register_sidebar(array(
		'name'          => __('Servizi','upbootwp'),
		'id'            => 'servizi',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4>',
	));
  
    register_sidebar(array(
		'name'          => __('Footer 1','upbootwp'),
		'id'            => 'footer1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4>',
	));
	register_sidebar(array(
		'name'          => __('Footer 2','upbootwp'),
		'id'            => 'footer2',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4>',
	));
	register_sidebar(array(
		'name'          => __('Footer 3','upbootwp'),
		'id'            => 'footer3',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4>',
	));
	
}
add_action( 'widgets_init', 'upbootwp_widgets_init' );


################################################################################
// Loading All CSS Stylesheets
################################################################################
function bootstrapwp_css_loader() {
	wp_enqueue_style('bootstrapwp', get_template_directory_uri().'/css/bootstrapwp.css', false ,'0.90', 'all' );
    //wp_enqueue_style('bootstrapcsscdn', '//maxcdn.bootstrapcdn.com/bootstrap/3.3.2/css/bootstrap.min.css');
	wp_enqueue_style('style', get_template_directory_uri().'/style.css');
	
	/* MMENU */
	wp_enqueue_style('mmenu', get_template_directory_uri().'/js/mmenu/css/jquery.mmenu.all.css', false);
    
	/* ENTYPO */
	wp_enqueue_style('entypo', get_template_directory_uri().'/fonts/entypo/entypo.css');
    
    wp_enqueue_style('googlefont', '//fonts.googleapis.com/css?family=Open+Sans+Condensed:300,700|Open+Sans:300italic,400italic,700italic,400,700,300');
	
	/* NEWS TICKER */
	//wp_enqueue_style('newsticker', get_template_directory_uri().'/js/newsticker/styles/ticker-style.css');
	
	/* OWL CAROUSEL */
	wp_enqueue_style('owl-carousel', get_template_directory_uri().'/js/owl-carousel/owl.carousel.css');
	wp_enqueue_style('owl-carousel-theme', get_template_directory_uri().'/js/owl-carousel/owl.theme.css');
	
	/* COUNTER JS */
	//wp_enqueue_style('counterjs', get_template_directory_uri().'/js/counterjs/counter.css');
	
	/* FLEXSLIDER */
	//wp_enqueue_style('flexslider', get_template_directory_uri().'/js/flexslider/flexslider.css');
	
	/* FRESCO LIGHTBOX */
	//wp_enqueue_style('fresco', get_template_directory_uri().'/js/fresco/fresco.css');
	
	/* TOOLTIPSTER */
	//wp_enqueue_style('tooltipster', get_template_directory_uri().'/js/tooltipster/css/tooltipster.css');
	
	/* ICONMOON */
	//wp_enqueue_style('corlytics-icon', get_template_directory_uri().'/fonts/corlytics-icon/corlytics-icon.css');
}
add_action('wp_enqueue_scripts', 'bootstrapwp_css_loader');

################################################################################
// Loading all JS Script Files.  Remove any files you are not using!
################################################################################
function bootstrapwp_js_loader() {
	//wp_enqueue_script( 'upbootwp-jQuery', get_template_directory_uri().'/js/jquery.js',array(),'2.0.3',true);
	//wp_enqueue_script( 'upbootwp-basefile', get_template_directory_uri().'/js/bootstrap.min.js',array(),'20130905',true);
    wp_enqueue_script( 'bootstrap-cdn', '//maxcdn.bootstrapcdn.com/bootstrap/3.3.2/js/bootstrap.min.js');
	wp_enqueue_script( 'dropdown-hover', get_template_directory_uri().'/js/bootstrap-hover-dropdown.min.js',array('jquery'),'0.90', true );
	
	//wp_enqueue_script( 'sharrre', get_template_directory_uri().'/js/jquery.sharrre.min.js',array('jquery'),'1.7', true );
	//wp_enqueue_script( 'sharrre-jquery', '//code.jquery.com/jquery-1.7.0.min.js');
	
	//wp_enqueue_script('masonry', get_template_directory_uri().'/js/masonry.pkgd.min.js');
    
    wp_enqueue_script('equalheight', get_template_directory_uri().'/js/jquery.equalheights.min.js');
	
	/* Infinite Scroll */
	//wp_enqueue_script('infinitescroll', get_template_directory_uri().'/js/jquery.infinitescroll.js', array('jquery'),'1.0', false );
	
	//wp_enqueue_script('imagesloaded', get_template_directory_uri().'/js/imagesloaded.js');
	
    /* MMENU */
	wp_enqueue_script( 'mmenu-js', get_template_directory_uri().'/js/mmenu/js/jquery.mmenu.min.all.js','','2.0',true);
    
	wp_enqueue_script('gmaps', get_template_directory_uri().'/js/gmaps.js');	
	
	/* STYKY NAV*/
	//wp_enqueue_script( 'stiky', get_template_directory_uri().'/js/jquery.sticky.js',array('jquery'),'1.0', true );
	
	/* OWL CAROUSEL */
	wp_enqueue_script('owl-carousel', get_template_directory_uri().'/js/owl-carousel/owl.carousel.min.js');	
	
	wp_enqueue_script('custom', get_template_directory_uri().'/js/custom.js', array('jquery'),'1.0', true );
	
	/* WAYPOINT */
	wp_enqueue_script('waypoint', get_template_directory_uri().'/js/waypoints.js');
	
	/* WAYPOINT */
	//wp_enqueue_script('counterjs', get_template_directory_uri().'/js/counterjs/flipcounter.min.js');
		
	/* PRELOADER */
	//wp_enqueue_script('preloader', get_template_directory_uri().'/js/jquery.queryloader2.min.js', array('jquery'),'1.0', false);
		
	//wp_enqueue_script('lazy-load', get_template_directory_uri().'/js/jquery.lazyload.min.js' );
    
    /* MODERNIZR */
    wp_enqueue_script('modernizr', get_template_directory_uri().'/js/modernizr.custom.js' );
	
	/* FLEXSLIDER */
	//wp_enqueue_script('flexslider', get_template_directory_uri().'/js/flexslider/jquery.flexslider.js');
	//wp_enqueue_script('shCore', get_template_directory_uri().'/js/flexslider/js/shCore.js');
	//wp_enqueue_script('shBrushXml', get_template_directory_uri().'/js/flexslider/js/shBrushXml.js');
	//wp_enqueue_script('shBrushJScript', get_template_directory_uri().'/js/flexslider/js/shBrushJScript.js');
	//wp_enqueue_script('mousewheel', get_template_directory_uri().'/js/flexslider/js/jquery.easing.js');
	//wp_enqueue_script('easing', get_template_directory_uri().'/js/flexslider/js/jquery.mousewheel.js');
	
	/* NEWS TICKER */
	
	//wp_enqueue_script('newsticker', get_template_directory_uri() . '/js/newsticker/includes/jquery.ticker.js');
	
	/* FRESCO LIGHTBOX */
	//wp_enqueue_script('fresco', get_template_directory_uri() . '/js/fresco/fresco.js');
		
	/* Transit */
	//wp_enqueue_script('transit', get_template_directory_uri() . '/js/jquery.transit.js');
	
	
	/* TOOLTIPSTER */
	//wp_enqueue_script('tooltipster', get_template_directory_uri() . '/js/tooltipster/js/jquery.tooltipster.min.js');
	
	//wp_enqueue_script('instafeed', get_template_directory_uri() . '/js/instafeed.min.js');
}
add_action('wp_enqueue_scripts', 'bootstrapwp_js_loader');

/**
 * Implement the Custom Header feature.
 */
//require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
//require get_template_directory().'/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
//require get_template_directory().'/inc/extras.php';

/**
 * Customizer additions.
 */
//require get_template_directory().'/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
//require get_template_directory().'/inc/jetpack.php';


/**
 * upbootwp_breadcrumbs function.
 * Edit the standart breadcrumbs to fit the bootstrap style without producing more css
 * @access public
 * @return void
 */
function upbootwp_breadcrumbs() {

	$delimiter = '&raquo;';
	$home = 'Home';
	$before = '<li class="active">';
	$after = '</li>';

	if (!is_home() && !is_front_page() || is_paged()) {

		echo '<ol class="breadcrumb">';

		global $post;
		$homeLink = get_bloginfo('url');
		echo '<li><a href="' . $homeLink . '">' . $home . '</a> ' . $delimiter . '</li> ';

		if (is_category()) {
			global $wp_query;
			$cat_obj = $wp_query->get_queried_object();
			$thisCat = $cat_obj->term_id;
			$thisCat = get_category($thisCat);
			$parentCat = get_category($thisCat->parent);
			if ($thisCat->parent != 0) echo(get_category_parents($parentCat, TRUE, ' ' . $delimiter . ' '));
			echo $before . single_cat_title('', false) . $after;

		} elseif (is_day()) {
			echo '<li><a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a></li> ' . $delimiter . ' ';
			echo '<li><a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a></li> ' . $delimiter . ' ';
			echo $before . get_the_time('d') . $after;

		} elseif (is_month()) {
			echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a></li> ' . $delimiter . ' ';
			echo $before . get_the_time('F') . $after;

		} elseif (is_year()) {
			echo $before . get_the_time('Y') . $after;

		} elseif (is_single() && !is_attachment()) {
			if ( get_post_type() != 'post' ) {
				$post_type = get_post_type_object(get_post_type());
				$slug = $post_type->rewrite;
				echo '<a href="' . $homeLink . '/' . $slug['slug'] . '/">' . $post_type->labels->singular_name . '</a></li> ' . $delimiter . ' ';
				echo $before . get_the_title() . $after;
			} else {
				$cat = get_the_category(); $cat = $cat[0];
				echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
				echo $before . get_the_title() . $after;
			}

		} elseif (!is_single() && !is_page() && get_post_type() != 'post' && !is_404()) {
			$post_type = get_post_type_object(get_post_type());
			echo $before . $post_type->labels->singular_name . $after;

		} elseif (is_attachment()) {
			$parent = get_post($post->post_parent);
			$cat = get_the_category($parent->ID); $cat = $cat[0];
			echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
			echo '<a href="' . get_permalink($parent) . '">' . $parent->post_title . '</a></li> ' . $delimiter . ' ';
			echo $before . get_the_title() . $after;

		} elseif ( is_page() && !$post->post_parent ) {
			echo $before . get_the_title() . $after;

		} elseif ( is_page() && $post->post_parent ) {
			$parent_id  = $post->post_parent;
			$breadcrumbs = array();
			while ($parent_id) {
				$page = get_page($parent_id);
				$breadcrumbs[] = '<a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a></li>';
				$parent_id  = $page->post_parent;
			}
			$breadcrumbs = array_reverse($breadcrumbs);
			foreach ($breadcrumbs as $crumb) echo $crumb . ' ' . $delimiter . ' ';
			echo $before . get_the_title() . $after;

		} elseif ( is_search() ) {
			echo $before . 'Search results for "' . get_search_query() . '"' . $after;

		} elseif ( is_tag() ) {
			echo $before . 'Posts tagged "' . single_tag_title('', false) . '"' . $after;

		} elseif ( is_author() ) {
			global $author;
			$userdata = get_userdata($author);
			echo $before . 'Articles posted by ' . $userdata->display_name . $after;

		} elseif ( is_404() ) {
			echo $before . 'Error 404' . $after;
		}

		if ( get_query_var('paged') ) {
			if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
			echo ': ' . __('Page') . ' ' . get_query_var('paged');
			if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
		}

		echo '</ol>';

	}
}





/*
| --------------------------------------------------------------------------------------------------------------------------------------
| 
|
|										Qui inizia Dueper
|
|
| --------------------------------------------------------------------------------------------------------------------------------------
|
| */

/*
| -------------------------------------------------------------------
| Rimuovo avviso di upgrade nel backend
| -------------------------------------------------------------------
|
| */

add_action('admin_menu','wphidenag');
function wphidenag() {
remove_action( 'admin_notices', 'update_nag', 3 );
}



/*
| -------------------------------------------------------------------
| Personalizzo URL del Logo nella pagina di login
| -------------------------------------------------------------------
|
| */
add_filter( 'login_headerurl', 'my_custom_login_url' );
function my_custom_login_url($url) {
	$siteURL = get_bloginfo('url');
	return $siteURL;
}

/*
| -------------------------------------------------------------------
| Personalizzo Logo nel back-end di wordpress
| -------------------------------------------------------------------
|
| */

add_action('admin_head', 'dueper_admin_custom_logo');
add_action('wp_head', 'dueper_admin_custom_logo');

function dueper_admin_custom_logo() {
echo '
<style type="text/css">
#wp-admin-bar-wp-logo { display:none !important; }
</style>
';
}


/*
| -------------------------------------------------------------------
| Personalizzo Footer nel back-end di wordpress
| -------------------------------------------------------------------
|
| */

function remove_footer_admin () {
echo 'Creato da <a href="//www.emberware.it" target="_blank">EmberWare srls</a> a partire da <a href="http://www.wordpress.org" target="_blank">WordPress</a></p>';
}

add_filter('admin_footer_text', 'remove_footer_admin');



/*
| -------------------------------------------------------------------
| Disabilito widget nella dashboard di wordpress
| -------------------------------------------------------------------
|
| */

function dueper_remove_dashboard_widgets() {
	global $wp_meta_boxes;

	unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_quick_press']); // disabilito quick press nella dashboard
	unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_incoming_links']); // disabilito Link in entrata nella dashboard
	//unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_right_now']); // disabilito Riassunto sito (numero di post/commenti ecc..) nella dashboard
	unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_plugins']); // disabilito widget plugin nella dashboard
	unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_recent_drafts']); // disabilito widget Bozze recenti nella dashboard
	unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_recent_comments']); // disabilito widget dei commenti recenti nella dashboard
	unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_primary']); // disabilito widget Wordpress Blog nella dashboard
	unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_secondary']); // disabilito widget Other Wordpress news nella dashboard

}

// add_action('wp_dashboard_setup', 'dueper_remove_dashboard_widgets' );




/*
| -------------------------------------------------------------------
| Aggiungo widget personalizzato nel back-end di wordpress
| -------------------------------------------------------------------
|
| */

// add_action('wp_dashboard_setup', 'dueper_dashboard_widgets');

function dueper_dashboard_widgets() {
global $wp_meta_boxes;

wp_add_dashboard_widget('dueper_help_widget', 'Hai bisogno di aiuto?', 'dueper_dashboard_help');
}

function dueper_dashboard_help() {
echo '<p><h2>Hai riscontrato dei problemi che non rieci a risolvere?</h2><br /><a href="http://www.dueper.net" target="_blank" class="button button-primary button-large">Contattaci</a></p>';
}




add_filter( 'avatar_defaults', 'dueper_newgravatar' );

function dueper_newgravatar ($avatar_defaults) {
$myavatar = get_bloginfo('template_directory') . '/img/gravatar.png'; //inserire nella cartella /img/ la png
$avatar_defaults[$myavatar] = get_current_theme();
return $avatar_defaults;
}



// rimuovo informazioni
add_filter('user_contactmethods','dueper_hide_profile_fields',10,1);

function dueper_hide_profile_fields( $contactmethods ) {
unset($contactmethods['aim']);
unset($contactmethods['jabber']);
unset($contactmethods['yim']);
return $contactmethods;
}

// aggiungo nuove informazioni
function dueper_new_contact_methods( $contactmethods ) {
// Add Twitter
// $contactmethods['twitter'] = 'Twitter';
//add Facebook
// $contactmethods['facebook'] = 'Facebook';
//add Facebook
// $contactmethods['youtube'] = 'Youtube';


return $contactmethods;
}
add_filter('user_contactmethods','dueper_new_contact_methods',10,1);


/*
| -------------------------------------------------------------------
| Aggiungo Immagine copertnina nei feed RSS
| -------------------------------------------------------------------
|
| */

function dueper_rss_post_thumbnail($content) {
global $post;
if(has_post_thumbnail($post->ID)) {
$content = '<p>' . get_the_post_thumbnail($post->ID) .
'</p>' . get_the_content();
}
return $content;
}
add_filter('the_excerpt_rss', 'dueper_rss_post_thumbnail');
add_filter('the_content_feed', 'dueper_rss_post_thumbnail');



/*
| -------------------------------------------------------------------
| Regolo la compressione delle immagini 
| (valore fornito nel pannello del tema nel backend)
| -------------------------------------------------------------------
|
| */
function dueper_qualita(){
	$compressione = '100'; // assegno alla compressione il valore settato nel pannello del tema nel backend 
	return $compressione;
	}

add_filter('jpeg_quality', 'dueper_qualita' );


/*
| -------------------------------------------------------------------
| Sostituisco Howdy con un testo custom
| (valore fornito nel pannello del tema nel backend)
| -------------------------------------------------------------------
|
| */

add_action( 'admin_bar_menu', 'wp_admin_bar_my_custom_account_menu', 11 );

function wp_admin_bar_my_custom_account_menu( $wp_admin_bar ) {
$user_id = get_current_user_id();
$current_user = wp_get_current_user();
$profile_url = get_edit_profile_url( $user_id );

if ( 0 != $user_id ) {
/* Add the "My Account" menu */
$avatar = get_avatar( $user_id, 28 );
$howdy = sprintf( __('YO! %1$s'), $current_user->display_name );
$class = empty( $avatar ) ? '' : 'with-avatar';

$wp_admin_bar->add_menu( array(
'id' => 'my-account',
'parent' => 'top-secondary',
'title' => $howdy . $avatar,
'href' => $profile_url,
'meta' => array(
'class' => $class,
),
) );

}
}


/*
| -------------------------------------------------------------------
| Revising Default Excerpt
| -------------------------------------------------------------------
| Adding filter to post excerpts to contain ...Continue Reading link
| */
function bootstrapwp_excerpt($more) {
  global $post;
  		return '...&nbsp;';
}
add_filter('excerpt_more', 'bootstrapwp_excerpt');


/*
| -------------------------------------------------------------------
| Revising Default Excerpt
| -------------------------------------------------------------------
| Adding filter to post excerpts to contain ...Continue Reading link
| */
function dueper_excerpt_length( $length ) {
	return 21;
}
add_filter( 'excerpt_length', 'dueper_excerpt_length', 999 );




/* Imposto le option pages */

if( function_exists('register_options_page') )
{
    register_options_page( 'General' );
}

/*
| -------------------------------------------------------------------
| Aggiungo funzione per is_post_type
| -------------------------------------------------------------------
|
| */

function is_post_type($type){
    global $wp_query;
    if($type == get_post_type($wp_query->post->ID)) return true;
    return false;
}

/*
| -------------------------------------------------------------------
| Aggiungo funzione per is_post_type
| -------------------------------------------------------------------
|
| */

function load_template_part($template_name, $part_name=null) {
    ob_start();
    get_template_part($template_name, $part_name);
    $var = ob_get_contents();
    ob_end_clean();
    return $var;
}

function add_attachment($content){
    $content .= load_template_part('includes/downloads');
    return $content;
}
 add_filter( 'the_content', 'add_attachment' ); 

// Favicon url
function dueper_custom_favicon(){
  echo '<link rel="shortcut icon" type="image/x-icon" href="'.get_template_directory_uri().'/img/favicon.png"/>';
}
add_action('wp_head', 'dueper_custom_favicon');
add_action('admin_head', 'dueper_custom_favicon');


/*
| -------------------------------------------------------------------
| Disabilito widget nella dashboard di wordpress
| -------------------------------------------------------------------
|
| */

add_action('wp_dashboard_setup', 'ew_remove_dashboard_widgets' );
function ew_remove_dashboard_widgets() {
	global $wp_meta_boxes;

	unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_quick_press']); // disabilito quick press nella dashboard
	unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_incoming_links']); // disabilito Link in entrata nella dashboard
	unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_right_now']); // disabilito Riassunto sito (numero di post/commenti ecc..) nella dashboard
	unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_plugins']); // disabilito widget plugin nella dashboard
	unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_recent_drafts']); // disabilito widget Bozze recenti nella dashboard
	unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_recent_comments']); // disabilito widget dei commenti recenti nella dashboard
	unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_primary']); // disabilito widget Wordpress Blog nella dashboard
	unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_secondary']); // disabilito widget Other Wordpress news nella dashboard
	unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_activity']); // disabilito widget activity nella dashboard
	

}


/*
| -------------------------------------------------------------------
| Aggiungo widget personalizzato nel back-end di wordpress
| -------------------------------------------------------------------
|
| */

add_action('wp_dashboard_setup', 'neuromi_dashboard_widgets');
// add_action('wp_dashboard_setup', 'dashboard_widgets_domande');
// add_action('wp_dashboard_setup', 'dashboard_widgets_progetti');
// add_action('wp_dashboard_setup', 'dashboard_widgets_j_club');
// add_action('wp_dashboard_setup', 'dashboard_widgets_news');

function neuromi_dashboard_widgets() {
global $wp_meta_boxes;
// wp_add_dashboard_widget('dashboard_help', 'DashBoard Help', 'dashboard_help');
add_meta_box( 'dashboard_help', 'DashBoard Help', 'dashboard_help', 'dashboard', 'normal', 'high' );
wp_add_dashboard_widget('dashboard_domande', 'Questions', 'dashboard_domande');
wp_add_dashboard_widget('dashboard_progetti', 'Projects', 'dashboard_progetti');
wp_add_dashboard_widget('dashboard_j_club_entries', 'Journal Club Entries', 'dashboard_j_club_entries');
wp_add_dashboard_widget('dashboard_news', 'News', 'dashboard_news');
}

function dashboard_help() {
	global $current_user;
	?>
	<h2>Benvenuti nell'area personale</h2>
Di seguito trovate pannelli con informazioni utili per voi, basate sulle keyword che avete selezionato nel <a href="/wp-admin/profile.php">profilo</a>: <b><?php
		$keywords = implode(', ', get_author_keywords($current_user->ID, true));
		if ($keywords){
			echo $keywords;
		}
		else {
			?>
				<br/>Non hai ancora impostato le keyword? impostale nel tuo <a href="/wp-admin/profile.php">profilo utente</a>
			<?php
		}
			
	?></b>

	<?php 
}

function dashboard_widgets_domande() {
global $wp_meta_boxes;
wp_add_dashboard_widget('dashboard_domande', 'Questions', 'dashboard_domande');
}
function dashboard_domande() {
	dashboard_list(post_type_list('question'), my_post_type_list('question'));
}

function dashboard_widgets_progetti() {
global $wp_meta_boxes;
wp_add_dashboard_widget('dashboard_progetti', 'Projects', 'dashboard_progetti');
}
function dashboard_progetti() {
	dashboard_list(post_type_list('project'), my_post_type_list('project'));
}

function dashboard_widgets_j_club() {
global $wp_meta_boxes;
wp_add_dashboard_widget('dashboard_j_club_entries', 'Journal Club Entries', 'dashboard_j_club_entries');
}
function dashboard_j_club_entries() {
	dashboard_list(post_type_list('journal-club-entry'), my_post_type_list('journal-club-entry'));
}

function dashboard_widgets_news() {
global $wp_meta_boxes;
wp_add_dashboard_widget('dashboard_news', 'News', 'dashboard_news');
}
function dashboard_news() {
	dashboard_list(post_type_list('news'), my_post_type_list('news'));
}
function post_type_list($post_type) {
	global $current_user;
	$keywords = get_author_keywords($current_user->ID, true);
	// echo json_encode($keywords);
	$posts_args = array(
		'post_type' => $post_type,
		'order' => 'ASC',
		'tag_slug__in' => $keywords,
		// 'orderby' => 'title',
		// 'nopaging' => true,
		'posts_per_page=' => 5,
	);
	$posts = get_posts($posts_args);
	wp_reset_query();
	wp_reset_postdata();
	return $posts;
}
function my_post_type_list($post_type) {
	global $current_user;
	// get_currentuserinfo();
	
	$posts_args = array(
		'post_type' => $post_type,
		'author' => $current_user->ID,
		'orderby' => 'modified',
		// 'order' => 'ASC',
		// 'nopaging' => true,
		'posts_per_page=' => 5,
	);
	$posts = get_posts($posts_args);
	wp_reset_query();
	wp_reset_postdata();
	return $posts;
}
function dashboard_list($posts = "", $my_posts = "") {
	?>
	<div id="activity-widget">
	<?php
	if ($my_posts){
	?>
	 <div id="published-posts" class="activity-block">
	  <h4>Mine, recently edited</h4>
	  <ul>
	  <?php
		foreach($my_posts as $post){
			// echo json_encode($gruppo);
			$post_id = $post->ID;
			$permalink = get_edit_post_link($post_id);
			$editlink = get_edit_post_link($post_id);
			$date_time = get_the_time('M jS, g:i a', $post->ID);
			$post_title = $post->post_title;
			?>
			<li><span><?php echo $date_time;?></span> <a href="<?php echo $permalink;?>"><?php echo $post_title;?></a> (<a href="<?php echo $editlink;?>">edit</a>)</li>
			<?php
		}
	  ?>
	  </ul>
	 </div>
	 <?php
	}
	if ($posts){
	?>
	 <div id="published-posts" class="activity-block">
	  <h4>Recently Published</h4>
	  <ul>
	  <?php
		foreach($posts as $post){
			// echo json_encode($gruppo);
			$post_id = $post->ID;
			$permalink = get_permalink($post_id);
			$date_time = get_the_time('M jS, g:i a', $post->ID);
			$post_title = $post->post_title;
			?>
			<li><span><?php echo $date_time;?></span> <a href="<?php echo $permalink;?>"><?php echo $post_title;?></a></li>
			<?php
		}
	  ?>
	  </ul>
	 </div>
	 <?php
	}
	 ?>
	</div>
	<?php
	// echo '<p><h2>Hai riscontrato dei problemi che non rieci a risolvere?</h2><br /><a href="http://www.dueper.net" target="_blank" class="button button-primary button-large">Contattaci</a></p>';
}

// // hook the translation filters
// add_filter(  'gettext',  'change_post_to_portfolio'  );
// add_filter(  'ngettext',  'change_post_to_portfolio'  );

// function change_post_to_portfolio( $translated ) {
  // $translated = str_ireplace(  'Posts',  'News',  $translated );  // ireplace is PHP5 only
  // $translated = str_ireplace(  'Post',  'News',  $translated );  // ireplace is PHP5 only
  // return $translated;
// }

// function change_post_menu_label() {
    // global $menu, $submenu;

    // $menu[5][0] = 'Portfolio';
    // $submenu['edit.php'][5][0] = 'Portfolio';
    // $submenu['edit.php'][10][0] = 'New Portfolio';
    // $submenu['edit.php'][16][0] = 'Portfolio Tags';
    // echo '';
// }
// add_action( 'init', 'change_post_menu_label' );

// function change_post_object_label() {
    // global $wp_post_types;

    // $labels = &$wp_post_types['post']->labels;
    // $labels->name = 'News';
    // $labels->singular_name = 'News';
    // $labels->add_new = 'New News';
    // $labels->add_new_item = 'New News';
    // $labels->edit_item = 'Edit News';
    // $labels->new_item = 'New News';
    // $labels->view_item = 'View News';
    // $labels->search_items = 'Search News';
    // $labels->not_found = 'Not found';
    // $labels->not_found_in_trash = 'Not found in trash';
// }
// add_action( 'admin_menu', 'change_post_object_label' );


// /*
// Plugin Name: Pods Admin Access
// */
// add_filter( 'pods_is_admin', 'slug_let_admins_admin', 10, 3 );
// function slug_let_admins_admin( $has_access, $cap, $capability ) {
	// $capability = 'CMS_admin';
	// return $capability;
// }

/*
| -------------------------------------------------------------------
| Add Customize item to TOP MENU
| -------------------------------------------------------------------
|
| */
function customize_menu_item ( $items, $args ) {
    if($args->theme_location == 'top'):
      if(is_user_logged_in()):
        $items .= '<li><a href="/wp-admin/profile.php" title="'.__('Profile','dueper').'">'.__('Profile','dueper').' <span class="glyphicon glyphicon-user"></span></a></li>';
        $items .= '<li><a href="'.wp_logout_url().'" title="'.__('Logout','dueper').'">'.__('Logout','dueper').' <span class="glyphicon glyphicon-log-out"></span></a></li>';
      else:
        $items .= '<li><a href="'.wp_login_url().'" title="'.__('Login','dueper').'">'.__('Login','dueper').' <span class="glyphicon glyphicon-log-in"></span></a></li>';
        $items .= '<li><a href="'.wp_registration_url().'" title="'.__('Register','dueper').'">'.__('Register','dueper').' <span class="glyphicon glyphicon-user"></span></a></li>';
      endif;
    endif;
		
    return $items;
}
add_filter( 'wp_nav_menu_items', 'customize_menu_item', 10, 2 );


/*
| -------------------------------------------------------------------
| Add NEWS CPT to archives
| -------------------------------------------------------------------
|
| */
function add_custom_cpt( $query ) {
  if( is_category()) {
    if($query->is_main_query()){
      $query->set( 'post_type', array('post', 'news'));
      }
  }
  return $query;
}
add_filter( 'pre_get_posts', 'add_custom_cpt' );

/*
| -------------------------------------------------------------------
| Add Comments redirect
| -------------------------------------------------------------------
|
//| */
//add_filter('comment_post_redirect', 'redirect_after_comment');
//function redirect_after_comment($location)
//{
//return $_SERVER["HTTP_REFERER"];
//}

/*
*  Change the Options Page capability to 'manage_options'
*/

if( function_exists('acf_set_options_page_capability') )
{
    acf_set_options_page_capability( 'manage_acf_options' );
}

/**
 * Syncs the post_tag/keyword Terms
 *
 * @param int $term_id
 * @param int $tt_id
 * @param string $taxonomy
 * @return string
 */
function lp_duplicate_created_terms( $term_id, $tt_id, $taxonomy ) {
    if ( $taxonomy != 'post_tag' && $taxonomy != 'keyword' )
        return;




    static $count = 0;

    $term = get_term_by( 'id', $term_id, $taxonomy );

    $opposite = ( $taxonomy == 'post_tag' ) ? 'keyword' : 'post_tag';

    // Prevents function from running a second time in the following wp_insert_term
    if ( $count > 0 )
        $count = 0;
    else
        wp_insert_term( $term->name, $opposite, array( 'slug' => $term->slug, 'alias_of' => $term->slug, 'description' => $term->description ) );
    $count++;
}
add_action( "created_term", 'lp_duplicate_created_terms', 10, 3 );

add_action('pre_get_posts','users_own_attachments');
function users_own_attachments( $wp_query_obj ) {

    global $current_user, $pagenow;

    if( !is_a( $current_user, 'WP_User') )
        return;

    if( !in_array( $pagenow, array( 'upload.php', 'admin-ajax.php' ) ))
        return;

    if( !current_user_can('delete_pages') )
        $wp_query_obj->set('author', $current_user->ID );

    return;
}

add_action('pre_get_posts','search_filter');
function search_filter($query) {
  if ( !is_admin() && $query->is_main_query() ) {
    if ($query->is_search) {
		error_log(json_encode($query));
      $query->set('post_type', 'post');
    }
  }
}

function get_author_keywords($author_id, $return_slugs){
	$params = array(
		'hide_empty' => true,
	);
	if ($return_slugs)
		$params['fields'] = 'id=>slug';
	$terms = get_terms( 'keyword', $params );
		
	$keywords = array();
	if ( !empty( $terms ) ) {
		foreach ( $terms as $term ) { 
			if(is_object_in_term( $author_id, 'keyword', $term ))
				array_push($keywords, $term );
		}
	}
	return $keywords;
}

function print_persons($persons){
	foreach ( $persons as $person ){
		// $avatar = get_sub_field('picture');
		// var_dump($director);
		?>
		<div class="author">
		  <div class="avatarc">
			<?php echo $person["user_avatar"]; ?>
		  </div>
		  <div class="details">
			<h3><?php echo $person["display_name"];?></h3>
			<!--<span class="title"><?php //echo $person["user_description"];?></span>-->
			<a href="<?php echo get_author_posts_url($person["ID"]);?>" class="info-toggle">info</a>
		  </div>
		</div>
		<div style="clear: both;"></div>
	  <?php 
	}
}

add_action('wp_enqueue_scripts', 'bs_table_css_loader');
function bs_table_css_loader(){
	wp_enqueue_style( 'style-name', get_template_directory_uri() . '/assets/bootstrap-table/src/bootstrap-table.css' );
}

/*remove wpml config in user profile*/
global $sitepress;
remove_action( 'show_user_profile', array($sitepress, 'show_user_options'));
remove_action( 'personal_options_update', array($sitepress, 'save_user_options'));