<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <main id="main">
 *
 * @author Dueper Design
 * @package Dueper Theme
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
<title><?php wp_title( '|', true, 'right' ); bloginfo('name'); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<?php if(is_front_page()) : ?>
	
    <?php $id_default_image = get_field('immagine_di_default','option');
	$image_url = wp_get_attachment_image_src( $id_default_image, 'large' ) ?>

	<meta property="og:title" content="<?php the_title(); ?>" />
    <meta property="og:site_name" content="<?php echo get_bloginfo('name'); ?>" />
    <meta property="og:url" content="<?php echo esc_url( home_url( '/' ) ); ?>" />
    <meta property="og:type" content="website" />
    <meta property="og:description" content="Corlytics | Cut avoidable risk" />
    <meta property="og:image" content="<?php echo $image_url[0]; ?>" />

<?php else : ?>

    <?php //$image_preview = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'share' ); ?>
    <meta property="og:title" content="<?php the_title(); ?>" />
    <meta property="og:site_name" content="<?php echo get_bloginfo('name'); ?>" />
    <meta property="og:url" content="<?php the_permalink(); ?>" />
    <meta property="og:type" content="article" />
    <meta property="og:image" content="<?php echo $image_preview[0];?>" />
<?php endif; ?>

<?php wp_head(); ?>
<!--[if lt IE 9]>
    <script type='text/javascript' src="http://html5shiv.googlecode.com/svn/trunk/html5.js"></script>
    <script type='text/javascript' src="//cdnjs.cloudflare.com/ajax/libs/respond.js/1.4.2/respond.js"></script>
<![endif]-->



</head>

<body <?php body_class(); ?>>
<div id="main-wrapper">

<!--container-->
<div class="container">
    <header class="header">
        <div class="row">
            <div class="col-md-3">
                <a class="navbar-brand" href="/">
                    <img src="<?php bloginfo('template_url'); ?>/img/logo.png" class="img-responsive">
                </a>
            </div>
            <div class="col-md-9">
                <nav class="navbar-top navbar-default hidden-sm hidden-xs" role="navigation">
                    <div class="navbar-header">
                      <div class="navbar-collapse collapse pull-left">
                        <?php 
                        $args = array('theme_location' => 'top', 
                                      'container_class' => '', 
                                      'menu_class' => 'nav navbar-nav',
                                      'fallback_cb' => '',
                                      'menu_id' => 'top-menu',
                                      'walker' => new Upbootwp_Walker_Nav_Menu()); 
                        wp_nav_menu($args);
                        ?>
                        </div>
                        <div class="search-form-header visible-lg">
                            <?php get_search_form(); ?>
                        </div><!--search-form-header-->
                        
                    </div>
                </nav>
            </div>
        </div>
      
      <div class="social">
          <a href="/" target="_blank" class="facebook"><span class="icon-facebook"></span></a>
          <a href="/" target="_blank" class="twitter"><span class="icon-twitter"></span></a>
          <a href="/" target="_blank" class="googleplus"><span class="icon-google"></span></a>
      </div><!--social-->
      
    </header>
    
    <div class="bg-grey">
        <nav class="top-nav navbar navbar-default" role="navigation">
            <div class="navbar-header">

                <button type="button" id="menu-toggle" class="navbar-toggle">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>
                
                <?php
                if(is_user_logged_in()):
                  $menu = 'primary-member';
                else :
                  $menu = 'primary';
                endif;
                $args = array('theme_location' => $menu, 
                              'container_class' => 'navbar-collapse collapse pull-left', 
                              'menu_class' => 'nav navbar-nav',
                              'fallback_cb' => '',
                              'menu_id' => 'main-menu',
                              'walker' => new Upbootwp_Walker_Nav_Menu()); 
                wp_nav_menu($args);
                ?>

            </div>
        </nav>
    </div><!--bg-black-->
    
    
</div><!--container-->
    
<div class="container">
    <div id="site-content">
    
        