<?php
$cats = wp_get_post_categories($post->ID);
$cat = $cats[0];
$category = get_category($cat);

global $post;
$project_post_limit=4;
$question_post_limit=4;
$journal_post_limit=4;
$selected_area_projects = get_field('area_projects');
if($selected_area_projects)
	  $project_post_limit -= count($selected_area_projects);
$selected_area_questions = get_field('area_questions');
if($selected_area_questions)
	  $question_post_limit -= count($selected_area_questions);
$selected_area_journal = get_field('area_journal');
if($selected_area_journal)
	  $journal_post_limit -= count($selected_area_journal);
?>
<div class="private-area container">
      <h3 class="text-center private-area-title"><?php _e('Private Area'); ?></h3>
      <div class="row">
          <div class="col-md-4 first equalheight">
              <?php
              $project_args = array(
                  'post_type'     => 'project',
                  'posts_per_page'=> $project_post_limit,
                  'cat'           => $cat,
				  'post__not_in'  => $selected_area_projects,
              );
              // $project = new WP_Query($project_args);
			  $generic_area_projects = get_posts($project_args);
			  if($selected_area_projects){
				  if($project_post_limit){  
					$area_projects = array_merge($selected_area_projects, $generic_area_projects);
				  }
				  else{
					  $area_projects = $selected_area_projects;
				  }
			  }
			  else{
				  $area_projects = $generic_area_projects;
			  }
              if($area_projects): ?>
                  <div class="projects">
                      <h3 class="title"><?php _e('Projects'); ?> - <a href="<?php echo esc_url(home_url('/project/category/'.$category->slug)); ?>" class="view-all"><?php _e('View all'); ?></a></h3>
                      <?php foreach($area_projects as $post):
						setup_postdata($post);
                          //trovo icon del post type
                          $type = get_post_type();
                          $type_label = get_post_type_object($type);
                          $icon = $type_label->menu_icon; ?>
                          <article <?php post_class('intro-fade'); ?>>
                              <span class="dashicons <?php echo $icon; ?>"></span>
                              <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                                  <h5><?php the_title(); ?></h5>
                              </a>
                          </article><!--post-class-->
                      <?php endforeach; ?>
                  </div><!--projects-->
              <?php endif; wp_reset_postdata(); wp_reset_query();
              ?>
          </div><!--col-md-4-->
          <div class="col-md-4 equalheight">
              <?php
              $question_args = array(
                  'post_type'     => 'question',
                  'posts_per_page'=> $question_post_limit,
                  'cat'           => $cat,
				  'post__not_in'  => $selected_area_questions, 
              );
              // $question = new WP_Query($question_args);
			  $generic_area_questions = get_posts($question_args);
			  if($selected_area_questions){
				  if($question_post_limit){
					$area_questions = array_merge($selected_area_questions, $generic_area_questions);  
				  }
				  else{
					  $area_questions = $selected_area_questions;
				  }
			  }
			  else{
				  $area_questions = $generic_area_questions;
			  }
              if($area_questions):?>
                  <div class="questions">
                      <h3 class="title"><?php _e('Questions'); ?> - <a href="<?php echo esc_url(home_url('/question/category/'.$category->slug)); ?>" class="view-all"><?php _e('View all'); ?></a></h3>
                      <?php foreach($area_questions as $post):
							setup_postdata($post);
                          //trovo icon del post type
                          $type = get_post_type();
                          $type_label = get_post_type_object($type);
                          $icon = $type_label->menu_icon; ?>
                          <article <?php post_class('intro-fade'); ?>>
                              <span class="dashicons <?php echo $icon; ?>"></span>
                              <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                                  <h5><?php the_title(); ?></h5>
                              </a>
                          </article><!--post-class-->
                      <?php endforeach; ?>
                  </div><!--questions-->
              <?php endif; wp_reset_postdata(); wp_reset_query();
              ?>
          </div><!--col-md-4-->
          <div class="col-md-4 last equalheight">
              <?php
              $journal_args = array(
                  'post_type'     => 'journal_club_entry',
                  'posts_per_page'=> $journal_post_limit,
                  'cat'           => $cat,
				  'post__not_in'  => $selected_area_journal,
              );
              // $journal = new WP_Query($journal_args);
			   $generic_area_journal = get_posts($journal_args);
			  if($selected_area_journal){
				  if($journal_post_limit){
					$area_journal = array_merge($selected_area_journal, $generic_area_journal);
				  }
				  else{
					  $area_journal = $selected_area_journal;
				  }
			  }
			  else{
				  $area_journal = $generic_area_journal;
			  }
              if($area_journal): ?>
                  <div class="journal">
                      <h3 class="title"><?php _e('Journal club entries'); ?> - <a href="<?php echo esc_url(home_url('/journal_club_entry/category/'.$category->slug)); ?>" class="view-all"><?php _e('View all'); ?></a></h3>
                      <?php foreach($area_journal as $post):
							setup_postdata($post); //trovo icon del post type
                          $type = get_post_type();
                          $type_label = get_post_type_object($type);
                          $icon = $type_label->menu_icon; ?>
                          <article <?php post_class('intro-fade'); ?>>
                              <span class="dashicons <?php echo $icon; ?>"></span>
                              <date><?php echo get_the_date(); ?></date>
                              <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                                  <h5><?php the_title(); ?></h5>
                              </a>
                          </article><!--post-class-->
                      <?php endforeach; ?>
                  </div><!--journal-->
              <?php endif; wp_reset_postdata(); wp_reset_query();
              ?>
          </div><!--col-md-4-->
      </div><!--row-->
</div><!--private-area-->