<?php
$cats = wp_get_post_categories($post->ID);
$cat = $cats[0];

$desc       = get_the_content();
$research   = get_field('main_fields_of_research');
$lab        = get_field('laboratories');
$project    = get_field('active_projects');
?>


<div class="content">
    <div role="tabpanel">
        <ul class="nav nav-tabs" role="tablist" id="areaTab">
            <?php
            if($desc) echo '<li role="presentation" class="active"><a href="#desc" aria-controls="desc" role="tab" data-toggle="tab">'.__('Description').'</a></li>';
            if($research) echo '<li role="presentation"><a href="#research" aria-controls="research" role="tab" data-toggle="tab">'.__('Main fields of research').'</a></li>';
            if($lab) echo '<li role="presentation"><a href="#lab" aria-controls="lab" role="tab" data-toggle="tab">'.__('Laboratories').'</a></li>';
            if($project) echo '<li role="presentation"><a href="#project" aria-controls="project" role="tab" data-toggle="tab">'.__('Active Projects').'</a></li>';
            ?>
        </ul>
    </div><!--role="tabpanel"-->
    <div class="tab-content">
        <?php
        if($desc) echo '<div role="tabpanel" class="tab-pane active" id="desc">'.$desc.'</div>';
        if($research) echo '<div role="tabpanel" class="tab-pane" id="research">'.$research.'</div>';
        if($lab) echo '<div role="tabpanel" class="tab-pane" id="lab">'.$lab.'</div>';
        if($project) echo '<div role="tabpanel" class="tab-pane" id="project">'.$project.'</div>';
        ?>
    </div>
</div><!--content-->
</div><!--col-md-9-->