<?php
/**
 * Template Name: Pagina Eventi
 * The template used for displaying page content in page.php
 *
 * @author Dueper Design
 * @package Dueper Theme
 */

get_header(); 
    if(have_posts()):?>
      <header class="page-title">
        <h1><?php the_title(); ?></h1>
      </header>
        <div class="container">
            <div class="row">
                <div class="col-md-12 main-page-content">
                    
                    <div class="row">
                        <?php
                        $args = array('post_type'=>'event');
                        $news_query = new WP_Query($args);
                        if($news_query->have_posts()):
                            while($news_query->have_posts()): $news_query->the_post(); ?>
                                <div class="col-md-4 col-sm-6">
                                    <article <?php post_class('intro-fade equalheight'); ?>>
                                        <div class="content">
                                            <?php the_category(); ?>
                                            <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                                                <h3><?php the_title(); ?></h3>
                                            </a>
                                            <div>
                                            <?php the_excerpt(); ?>
                                            </div>
                                            <date><?php echo get_the_date(); ?></date>
                                        </div><!--content-->
                                    </article><!--post-class-->
                                </div><!--col-sm-6-->
                            <?php endwhile;
                        endif; ?>
                    </div><!--row-->

                    <?php if (function_exists('wp_pagenavi')) wp_pagenavi(); ?>

                </div><!--col-md-8-->
            </div><!--row-->
        </div><!--container-->
<?php endif; ?>
<?php get_footer(); ?>