<?php
/**
 * Template Name: Pagina Members
 * The template used for displaying page content in page.php
 *
 * @author Dueper Design
 * @package Dueper Theme
 */

get_header(); 
    if(have_posts()):?>
      <header class="page-title">
        <h1><?php the_title(); ?></h1>
      </header>
        <div class="container">
            <div class="row">
                <div class="col-md-8 main-page-content">
                    
					<?php
					$members = get_users( array(
						'role' => 'neuromi_member',
						'order' => 'ASC',
						'orderby' => 'display_name',
						// 'fields' => 'ID',
					));
					if($members):
					$member_list = array();
					foreach ($members as $member){
						// echo $member->ID;
						$member_to_add = array(
							'ID' => $member->ID,
							'user_email' => $member->user_email,
							'display_name' => $member->display_name,
							'profile' => '<a href="'.get_author_posts_url($member->ID).'" > Profile</a>',
						);
						array_push($member_list, $member_to_add);
					}
					?>
					<script src="<?php echo get_template_directory_uri();?>/assets/jquery.min.js"></script>
					<script src="<?php echo get_template_directory_uri();?>/assets/bootstrap/js/bootstrap.min.js"></script>
					<script src="<?php echo get_template_directory_uri();?>/assets/bootstrap-table/src/bootstrap-table.js"></script>
					<script src="<?php echo get_template_directory_uri();?>/ga.js"></script>
					<?php
					// echo var_dump($members);?>
					<table id="table" data-search="true">
					<thead> <tr>
						<th data-field="display_name">Nome</th>
						<th data-field="user_email">Email</th>
						<th data-field="profile">Profile</th>
					</tr> </thead>
					</table>
					<script>
					var $table = $("#table");
					$(function() {
						var data = <?php echo json_encode($member_list);?>;
						$table.bootstrapTable({data: data});
					});
					</script>
			    </div><!--scientific-committee-->
				<?php endif; ?>

                



                </div><!--col-md-8-->
            </div><!--row-->
        </div><!--container-->
<?php endif; ?>
<?php get_footer(); ?>