<?php
/**
 * The template for displaying Search Results pages.
 *
 * @author Dueper Design
 * @package Dueper Theme
 */

get_header(); 
if ( have_posts() ) : 
	$search_query = get_search_query();
	$search_terms = explode(" ",$search_query);
	$terms_list = array();
	foreach($search_terms as $search_term){
		$args = array(
			'orderby'           => 'name', 
			'order'             => 'ASC',
			'hide_empty'        => true,
			'search'            => $search_term,
		); 
		$terms = get_terms( 'post_tag', $args );
		$terms_list = array_merge($terms_list, $terms);
	}

?>

  <div class="page-title">
    <h5><?php _e( 'Search results for' ); ?></h5>
    <h3><?php echo get_search_query(); ?></h3>
  </div>

  <div class="container">
      <div class="row">
          <div class="col-md-8">
			<div class="media" style="margin-top: 15px;">
				Keywords:
				<ul class="list-inline">
                              <?php foreach($terms_list as $term):
								$term_link = get_term_link( $term->slug, 'post_tag' );
								if ( is_wp_error( $term_link ) ) continue;
								?>
								<li><a href="<?php echo $term_link; ?>" class="label label-primary"><?php echo $term->name; ?></a></li>
                              <?php endforeach; ?>
                            </ul>
			</div>
              <?php while ( have_posts() ) : the_post(); ?>
					
                  <div <?php post_class('intro-fade media'); ?>>
                    <div class="media-body">
                      <?php
                      $obj = get_post_type_object( get_post_type() );
                      echo $obj->labels->singular_name;
                      ?>
                      <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                        <h4 class="media-heading"><?php the_title(); ?></h4>
                      </a>
                      <?php the_excerpt(); ?>
                    </div><!--media-body-->
                  </div>  <!--media-->
                  <hr />
              <?php endwhile; ?>
          </div><!--col-md-8-->
          <div class="col-md-4">
              <?php get_sidebar(); ?>
          </div><!--col-md-4-->
      </div><!--row-->
  </div><!--container-->
    
<?php else : ?>
  <div class="page-title">
    <h5><?php _e( 'Nothing found for' ); ?></h5>
    <h3><?php echo get_search_query(); ?></h3>
  </div>

	<div class="container section-page">
	    <div class="row">
            <div class="col-md-8">
                <div class="single-post-content">
                    <p><?php _e( 'Non abbiamo trovato risultati con la ricerca corrente, prova con un\'altra parola chiave!'); ?></p>
                    <?php get_search_form(); ?>
                </div>
            </div><!--col-md-8-->
            <div class="col-md-4">
                    <?php get_sidebar(); ?>
                </div><!--col-md-4-->
        </div><!-- row -->
	</div><!-- container -->
	
<?php endif; ?>
			
<?php get_footer(); ?>