<?php
/**
 * The Template for displaying all single posts.
 *
 * @author Dueper Design
 * @package Dueper Theme
 */
 
 //trovo categoria corrente
$categories = wp_get_post_categories( $post->ID );
global $current_cat;
$current_cat = array();
foreach($categories as $category){
  $cat_obj = get_category( $category );
  array_push($current_cat, $cat_obj->cat_ID);
  // $current_cat = $cat_obj->slug;
}

$aree = get_the_terms($post->ID,'category');
if($aree):
  foreach($aree as $area):
    $name_area = $area->name;
    $cat = $area->term_id;
  endforeach;
endif;

// creao redirect alla research-area in questa categoria
$args_area = array(
    'post_type'     => 'research_area',
    'posts_per_page'=> 1,
    'cat'           => $cat
);
$areas = new WP_query($args_area);
if($areas->have_posts()):
  while( $areas->have_posts()) : $areas->the_post();
    $thumb = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'slide' );
    $url = $thumb['0'];
  endwhile;
endif;
wp_reset_query();

//trovo icon del post type
$type = get_post_type();
$type_label = get_post_type_object($type);
$icon = $type_label->menu_icon;


 
get_header(); ?>
	<?php if ( have_posts() ) : the_post(); ?>
        <div class="page-title">
          <h5><?php echo $name_area; ?></h5>
          <h3><span class="dashicons <?php echo $icon; ?>"></span> <?php the_title(); ?></h3>
        </div>
        <div class="container area-content">
            <div class="row">
                <div class="col-md-8">
                    <div class="single-post-content">
                        <div class="post-content">
                            <?php the_content(); ?>
                        </div><!--post-content-->
                        <hr>
                        <strong><?php _e('Written by ').the_author_posts_link(); ?></strong>
                    </div><!--single-post-content-->
                <div class="tag-container"><?php the_tags( 'Tags: ', ' &nbsp; ', '' ); ?></div>
                <?php comments_template(); ?> 
                </div><!--col-md-8-->
                <div class="col-md-4">
                    <?php get_template_part('includes/question-side'); ?>
                    <?php get_template_part('includes/area-news'); ?>
                </div><!--col-md-4-->
            </div>
        </div>
	<?php endif; // end of the loop. ?>
<?php get_footer(); ?>
