<?php
/**
 * The Template for displaying all single posts.
 *
 * @author Dueper Design
 * @package Dueper Theme
 */
$thumb = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'slide' );
$url = $thumb['0'];

//trovo categoria corrente
$categories = wp_get_post_categories( $post->ID );
global $current_cat;
$current_cat = array();
foreach($categories as $category){
  $cat_obj = get_category( $category );
  array_push($current_cat, $cat_obj->cat_ID);
  // $current_cat = $cat_obj->slug;
}

get_header(); ?>
	<?php if ( have_posts() ) : the_post(); ?>
        <?php $contact = get_field('contact'); ?>
        <div class="area-title" style="background-image:url(<?php echo $url; ?>);">
            <div class="container">
                <div class="row">
                    <?php if($contact): ?>
                        <div class="col-md-8">
                            <h1 class="post-title"><?php the_title(); ?></h1>
                        </div><!--col-md-8-->
                        <div class="col-md-4">
                            <div class="user-contact-info">
                                <figure>
                                    <?php echo $contact['user_avatar']; ?>
                                </figure>
                                <div class="info-content">
                                    <span class="name"><?php echo $contact['display_name']; ?></span>
                                    <?php echo __('Email:').' <a href="mailto:'.$contact['user_email'].'">'.$contact['user_email'].'</a>'; ?>
                                </div><!--info-content-->
                              <div class="clearfix"></div>
                            </div><!--user-contact-info-->
                        </div><!--col-md-4-->
                    <?php else : ?>
                        <div class="col-md-12">
                            <h1 class="post-title"><?php the_title(); ?></h1>
                        </div><!--col-md-8-->
                    <?php endif; ?>
                </div><!--row-->
            </div><!--container-->
        </div><!--area-title-->
        <div class="container area-content">
          <div class="row">
            <div class="col-lg-3 col-md-12">
              <?php get_template_part('includes/area-news'); ?>
            </div><!--col-md-3-->
            <div class="col-lg-9 col-md-12">
              <?php if(is_user_logged_in()) get_template_part('includes/area-private'); ?>
              <?php get_template_part('includes/area-public'); ?>
            </div><!--col-md-9-->
          </div><!--row-->
        </div><!--container-->
	<?php endif; // end of the loop. ?>
<?php get_footer(); ?>
