<?php
/**
 * The Template for displaying all single posts.
 *
 * @author Dueper Design
 * @package Dueper Theme
 */
get_header(); ?>
	<?php if ( have_posts() ) : the_post(); ?>
        <div class="page-title">
          <h3><?php _e('News & events'); ?></h3>
        </div>
        <div class="container">
            <div class="row">
                <div class="col-md-8">
                    <div class="single-post-content">
                        <?php the_category(); ?>
                        <h1 class="post-title"><?php the_title(); ?></h1>
                        <date><?php echo get_the_date(); ?></date>
                        <div class="post-content">
                            <?php the_post_thumbnail('medium',array('class'=>'alignright img-responsive')); ?>
                            <?php the_content(); ?>
                        </div><!--post-content-->
                      
                      <hr>
                      <strong><?php _e('Written by ').the_author_posts_link(); ?></strong>
                    </div><!--single-post-content-->
                <div class="tag-container"><?php the_tags( 'Tags: ', ' &nbsp; ', '' ); ?></div>
                </div><!--col-md-8-->
                <div class="col-md-4">
                    <?php get_sidebar('news'); ?>
                </div><!--col-md-4-->
            </div>
        </div>
	<?php endif; // end of the loop. ?>
<?php get_footer(); ?>
