<?php
/**
 * The template for displaying Archive pages.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @author Dueper Design
 * @package Dueper Theme
 */

$tag_id = get_query_var('tag_id');
$args = array(
  'posts_per_page'  => -1,
  'post_type'       => 'any',
  'tag_id'          => $tag_id
);
$tax_query = new WP_Query($args);

get_header(); ?>
<div class="page-title">
  <h3><?php single_cat_title(); ?></h3>
</div>
<?php if($tax_query->have_posts()): ?>
  <div class="container">
    <div class="row">
        <div class="col-md-8 main-page-content">
            <?php while ( $tax_query->have_posts() ) : $tax_query->the_post();
                $obj = get_post_type_object( get_post_type());
                ?>
                <article <?php post_class('intro-fade media'); ?>>
                  <div class="media-body content">
                    <?php the_category(); ?>
                    <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                      <h6 class="media-heading"><?php echo '<span>'.$obj->labels->singular_name.':</span> '.get_the_title(); ?></h6>
                    </a>
                    <?php the_excerpt(); ?>
                  </div><!--media-body-->
                </article>  <!--media-->
                <hr />
            <?php endwhile; ?>
        </div><!--col-md-8-->
        <div class="col-md-4">
            <?php get_sidebar(); ?>
        </div><!--col-md-4-->
    </div><!--row-->
  </div><!--container-->
<?php endif; ?>
							
<?php get_footer(); ?>
