<?php

namespace App\Controllers;

use Sober\Controller\Controller;

class App extends Controller
{
    public function siteName()
    {
        return get_bloginfo('name');
    }

    public static function title()
    {
        if (is_home()) {
            if ($home = get_option('page_for_posts', true)) {
                return get_the_title($home);
            }
            return __('Latest Posts', 'muy-lindo');
        }
        if (is_archive()) {
            return get_the_archive_title();
        }
        if (is_search()) {
            return sprintf(__('Search Results for %s', 'muy-lindo'), get_search_query());
        }
        if (is_404()) {
            return __('Not Found', 'muy-lindo');
        }
        return get_the_title();
    }

    public static function socialbar()
    {
        $html = '<div class="socialbar-container"><div class="socialbar">';
            if(get_theme_mod('muy_social_facebook')) $html .= '<a href="'.esc_url(get_theme_mod('muy_social_facebook')).'" target="_blank" title="'.__('Facebook','muy-lindo').'" class="facebook"><img src="resources/assets/images/social/facebook.svg"/>.</span></a>';
            if(get_theme_mod('muy_social_twitter')) $html .= '<a href="'.esc_url(get_theme_mod('muy_social_twitter')).'" target="_blank" title="'.__('Twitter','muy-lindo').'" class="twitter"><span class="icon-twitter"></span></a>';
            if(get_theme_mod('muy_social_whatsapp')) $html .= '<div><a href="https://api.whatsapp.com/send?phone='.get_theme_mod('muy_social_whatsapp').'" target="_blank" title="'.__('Whatsapp','muy-lindo').'" class="whatsapp"><span class="icon-whatsapp"></span></a></div>';
            if(get_theme_mod('muy_social_youtube')) $html .= '<a href="'.esc_url(get_theme_mod('muy_social_youtube')).'" target="_blank" title="'.__('YouTube','muy-lindo').'" class="youtube"><span class="icon-youtube"></span></a>';
            if(get_theme_mod('muy_social_vimeo')) $html .= '<a href="'.esc_url(get_theme_mod('muy_social_vimeo')).'" target="_blank" title="'.__('Vimeo','muy-lindo').'" class="vimeo"><span class="icon-vimeo"></span></a>';
            if(get_theme_mod('muy_social_linkedin')) $html .= '<a href="'.esc_url(get_theme_mod('muy_social_linkedin')).'" target="_blank" title="'.__('LinkedIn','muy-lindo').'" class="linkedin"><span class="icon-linkedin"></span></a>';
            if(get_theme_mod('muy_social_instagram')) $html .= '<a href="'.esc_url(get_theme_mod('muy_social_instagram')).'" target="_blank" title="'.__('Instagram','muy-lindo').'" class="instagram"><span class="icon-instagram"></span></a>';
            if(get_theme_mod('muy_social_pinterest')) $html .= '<a href="'.esc_url(get_theme_mod('muy_social_pinterest')).'" target="_blank" title="'.__('Pinterest','muy-lindo').'" class="pinterest"><span class="icon-pinterest"></span></a>';
            if(get_theme_mod('muy_social_flickr')) $html .= '<a href="'.esc_url(get_theme_mod('muy_social_flickr')).'" target="_blank" title="'.__('Flickr','muy-lindo').'" class="flickr"><span class="icon-flickr"></span></a>';
        $html .= '</div></div>';

        return $html;
    }

    public function credits()
    {
        return __('Designed and developed by <a class="underline" href="https://dueper.net" target="_blank">Dueper Studio</a>', 'muy-lindo');
    }
}
