<?php

namespace App;

/**
 * Custom login in admin login page
 */
add_filter( 'login_headerurl', function ($url) {
    $siteURL = esc_url(home_url());
    return $siteURL;
}, 10, 2);

/**
 * Custom logo in login page
 */
add_action('login_head', function () {
    $img = asset_path('images/logo.svg');
    echo '<style type="text/css">
    body {
        background-color: #EDEFC9 !important;
    }
    h1 a {
        background-image: url('.$img.') !important;
        background-size: contain !important;
        background-position: center !important;
        height: 0 !important;
        padding-bottom: 30% !important;
        width: 80% !important;
    }</style>';
});

/**
 * Custom logo in adminmenu
 */
add_action('admin_head', function () {
    $img = asset_path('images/logo.svg');
    echo '<style type="text/css">
    #adminmenu {
        position: relative;
        margin-top: 0;
    }
    
    #adminmenu::before {
        content: "";
        display: block;
        position: relative;
        background-color: #EDEFC9;
        background-image: url('.$img.');
        background-size: 100px;
        background-position: center;
        background-repeat: no-repeat;
        height: 70px;
    }
    @media screen and (max-width: 960px) and (min-width: 783px) {
        #adminmenu {
            padding: 15px;
            height: auto;
        }
    }
    </style>';
});

/**
 * Custom Footer text in back-end
 */
add_filter('admin_footer_text', function () {
    $theme = wp_get_theme();
    printf(
        __('&#x1F528; Created by <a href="%s" target="_blank">%s</a> from <a href="http://www.wordpress.org" target="_blank">WordPress</a></p>', 'muy-lindo'),
        $theme->get( 'AuthorURI' ),
        $theme->get( 'Author' )
    );
}, 10);


/**
 *  Replace Howdy with custom text
 */
add_action( 'admin_bar_menu', function ( $wp_admin_bar ) {
    $user_id = get_current_user_id();
    $current_user = wp_get_current_user();
    $profile_url = get_edit_profile_url( $user_id );
    if ( 0 != $user_id ) :
      /* Add the "My Account" menu */
      $avatar = get_avatar( $user_id, 28 );
      $howdy = sprintf( __('&#128075 %1$s', 'muy'), $current_user->display_name );
      $class = empty( $avatar ) ? '' : 'with-avatar';

      $wp_admin_bar->add_menu( array(
        'id' => 'my-account',
        'parent' => 'top-secondary',
        'title' => $howdy . $avatar,
        'href' => $profile_url,
        'meta' => array(
        'class' => $class,
        ),
        ));
    endif;
}, 11, 1);




/**
 * Add custon styles button in admin editor
 */
add_filter('mce_buttons_2', function ($buttons) {
    array_unshift($buttons, 'styleselect');
    return $buttons;
});

/**
 * Add custon styles in admin editor
 */
add_filter( 'tiny_mce_before_init', function ( $init_array ) {
    $style_formats = array(
        // Each array child is a format with it's own settings
        array(
            'title' => 'Text small',
            'block' => 'span',
            'classes' => 'has-small-font-size',
            'exact' => true,
            'wrapper' => true,
        ),
        array(
            'title' => 'Text medium',
            'block' => 'span',
            'classes' => 'has-normal-font-size',
            'exact' => true,
            'wrapper' => true,
        ),
        array(
            'title' => 'Text large',
            'block' => 'span',
            'classes' => 'has-large-font-size',
            'exact' => true,
            'wrapper' => true,
        ),
        array(
            'title' => 'Text XL',
            'block' => 'span',
            'classes' => 'has-xl-font-size',
            'exact' => true,
            'wrapper' => true,
        ),
        array(
            'title' => 'Text 2XL',
            'block' => 'span',
            'classes' => 'has-2-xl-font-size',
            'exact' => true,
            'wrapper' => true,
        ),
        array(
            'title' => 'Text 3XL',
            'block' => 'span',
            'classes' => 'has-3-xl-font-size',
            'exact' => true,
            'wrapper' => true,
        ),
        array(
            'title' => 'Text 4XL',
            'block' => 'span',
            'classes' => 'has-4-xl-font-size',
            'exact' => true,
            'wrapper' => true,
        ),
        array(
            'title' => 'Text 5XL',
            'block' => 'span',
            'classes' => 'has-5-xl-font-size',
            'exact' => true,
            'wrapper' => true,
        ),
        array(
            'title' => 'Text 6XL',
            'block' => 'span',
            'classes' => 'has-6-xl-font-size',
            'exact' => true,
            'wrapper' => true,
        ),
    );
    // Insert the array, JSON ENCODED, into 'style_formats'
    $init_array['style_formats'] = json_encode( $style_formats );
    return $init_array;
}, 10, 1);


/**
 * Add custon styles button in admin editor
 */

add_action( 'admin_head', function () {
    wp_register_style('muy_admin_style', asset_path('styles/admin.css'));
    wp_enqueue_style('muy_admin_style');
});
