<?php

namespace App;

/**
 *  Remove useless archive title format 
 */

add_filter('get_the_archive_title', function ($title) {
  if (is_category()) {
    $title = single_cat_title('', false);
  } elseif (is_tag()) {
    $title = single_tag_title('', false);
  } elseif (is_author()) {
    $title = '<span class="vcard">' . get_the_author() . '</span>';
  } elseif (is_tax()) { //for custom post types
    $title = sprintf(__('%1$s'), single_term_title('', false));
  } elseif (is_post_type_archive()) {
    $title = post_type_archive_title('', false);
  }
  return $title;
});

/**
 * Add featured image in RSS
 */
add_filter('the_excerpt_rss', __NAMESPACE__ . '\\rss_post_thumbnail', 10, 2);
add_filter('the_content_feed', __NAMESPACE__ . '\\rss_post_thumbnail', 10, 2);
function rss_post_thumbnail($content)
{
  global $post;
  if (has_post_thumbnail($post->ID)) :
    $content = '<p>' . get_the_post_thumbnail($post->ID) .
      '</p>' . get_the_content();
  endif;
  return $content;
}


/**
 * Revising Default Excerpt
 */
add_filter('excerpt_more', function ($more) {
  global $post;
  return '...';
}, 10, 2);


/**
 * Revising Default Excerpt
 */
add_filter('excerpt_length', function ($length) {
  return 20;
}, 10, 2);


/**
 * Wrap oEmbed with container
 */
add_filter('embed_oembed_html', function ($html) {
  return "<div class='video-responsive'>{$html}</div>";
}, 10, 1);


/**
 * Add Language selector in menu
 */
if (function_exists('icl_get_languages')) {
  add_filter('wp_nav_menu_items', function ($items, $args) {
      $languages = icl_get_languages('skip_missing=0&orderby=code');
      if ($languages) {
          $menu_locations = ['right_menu', 'overlay_primary_navigation']; // Define menu locations as an array
          if (in_array($args->theme_location, $menu_locations)) { // Check if the current theme location is in the array
              // Find the currently active language
              $active_language = null;
              foreach ($languages as $l) {
                  if ($l['active']) {
                      $active_language = $l;
                      break;
                  }
              }
              if ($active_language) {
                  $items .= '<li class="menu-item menu-item-language menu-item-has-children"><a href="#" class="dropdown-toggle">' . $active_language['code'] . ' </a><ul class="sub-menu dropdown-menu">';
              }
              // Generate dropdown menu items excluding the active language
              foreach ($languages as $l) :
                  if (!$l['active']) :
                      $items .= '<li><a href="' . $l['url'] . '">' . $l['code'] . '</a>';
                  endif;
              endforeach;
              $items .= '</ul></li>';
          }
      }

      return $items;
  }, 10, 2);
}
