<?php

namespace App;

/**
 * Theme Customization - header
 */

// Sections

$panels[] = array(
	'id' => 'muy_general',
	'title' => __('General Options', 'muy-lindo'),
	'priority' => '45'
);

$sections[] = array(
	'id' => 'muy_buttons',
	'title' => __('Buttons Style', 'muy-lindo'),
	'priority' => '50',
	'panel' => 'muy_general',
	'description' => __('Configure the buttons style', 'muy-lindo')
);

$options['muy_buttons_radius'] = array(
	'id' => 'muy_buttons_radius',
	'label'   => __('Site Button Radius', 'muy_lindo'),
	'section' => 'muy_buttons',
	'default' => 0,
	'type'    => 'text',
	'description' => __('Enter the number of pixel','muy_lindo'),
);

$options['muy_buttons_height'] = array(
	'id' => 'muy_buttons_height',
	'label'   => __('Site buttons height', 'muy-lindo'),
	'section' => 'muy_buttons',
	'type'    => 'select',
	'default' => '0.75rem',
	'choices' => array(
		'0.5rem' => __('Short', 'muy-lindo'),
		'0.75rem' => __('Medium', 'muy-lindo'),
		'1rem' => __('Tall', 'muy-lindo'),
	),
);

$sections[] = array(
	'id' => 'muy_buttons',
	'title' => __('Buttons Style', 'muy-lindo'),
	'priority' => '55',
	'panel' => 'muy_general',
	'description' => __('Configure the buttons style', 'muy-lindo')
);

$options['muy_buttons_backgroundcolor'] = array(
	'id' => 'muy_buttons_backgroundcolor',
	'label'   => __('Button Background color', 'muy-lindo'),
	'default' => muy_default_color('main'),
	'description' => __('Choose the background color of the buttons', 'muy-lindo'),
	'section' => 'muy_buttons',
	'type'    => 'color',
);

$options['muy_buttons_invert_color'] = array(
	'id' => 'muy_buttons_invert_color',
	'label'   => __('outline buttons color', 'muy-lindo'),
	'default' => muy_default_color('main'),
	'section' => 'muy_buttons',
	'description' => __('Choose the color of the buttons outline', 'muy-lindo'),
	'type'    => 'color',
);

$options['muy_buttons_text_color'] = array(
	'id' => 'muy_buttons_text_color',
	'label'   => __('Button Text color', 'muy-lindo'),
	'default' => muy_default_color('main'),
	'description' => __('Choose the color of the buttons text', 'muy-lindo'),
	'section' => 'muy_buttons',
	'type'    => 'color',
);

$sections[] = array(
	'id' => 'muy_general_styles',
	'title' => __('General Style', 'muy-lindo'),
	'priority' => '50',
	'panel' => 'muy_general',
	'description' => __('Configure the body style', 'muy-lindo')
);

$options['muy_body_background_color'] = array(
	'id' => 'muy_body_background_color',
	'label'   => __('Body Background Color', 'muy-lindo'),
	'default' => muy_default_color('side'),
	'description' => __('Choose the background color of the body', 'muy-lindo'),
	'section' => 'muy_general_styles',
	'type'    => 'color',
);

$options['muy_body_text_color'] = array(
	'id' => 'muy_body_text_color',
	'label'   => __('Body Text Color', 'muy-lindo'),
	'default' => muy_default_color('main'),
	'description' => __('Choose the text color of the body', 'muy-lindo'),
	'section' => 'muy_general_styles',
	'type'    => 'color',
);

$sections[] = array(
	'id' => 'muy_fonts',
	'title' => __('Fonts', 'muy-lindo'),
	'priority' => '50',
	'panel' => 'muy_general',
	'description' => __('Configure the fonts', 'muy-lindo')
);

$options['muy_header_footer_font_rule'] = array(
	'id' => 'muy_header_footer_font_rule',
	'label'   => __('Header and Footer Font CSS rule', 'muy-lindo'),
	'description' => __('Ex - font-family: \'Roboto\', sans-serif; ', 'muy-lindo'),
	'section' => 'muy_fonts',
	'type'    => 'text',
);
$options['muy_header_footer_font_link'] = array(
	'id' => 'muy_header_footer_font_link',
	'label'   => __('Header and Footer Font link', 'muy-lindo'),
	'description' => __('Ex - &lt;link href="https://fonts.googleapis.com/css2?family=Kumbh+Sans:wght@300;400;700&display=swap" rel="stylesheet">', 'muy-lindo'),
	'section' => 'muy_fonts',
	'type'    => 'textarea',
);

$options['muy_titles_font_rule'] = array(
	'id' => 'muy_titles_font_rule',
	'label'   => __('Titles Font CSS rule', 'muy-lindo'),
	'description' => __('Ex - font-family: \'Roboto\', sans-serif; ', 'muy-lindo'),
	'section' => 'muy_fonts',
	'type'    => 'text',
);
$options['muy_titles_font_link'] = array(
	'id' => 'muy_titles_font_link',
	'label'   => __('Titles Font link', 'muy-lindo'),
	'description' => __('Ex - &lt;link href="https://fonts.googleapis.com/css2?family=Kumbh+Sans:wght@300;400;700&display=swap" rel="stylesheet">', 'muy-lindo'),
	'section' => 'muy_fonts',
	'type'    => 'textarea',
);

$options['muy_body_font_rule'] = array(
	'id' => 'muy_body_font_rule',
	'label'   => __('Body Font CSS rule', 'muy-lindo'),
	'description' => __('Ex - font-family: \'Roboto\', sans-serif; ', 'muy-lindo'),
	'section' => 'muy_fonts',
	'type'    => 'text',
);
$options['muy_body_font_link'] = array(
	'id' => 'muy_body_font_link',
	'label'   => __('Body Font link', 'muy-lindo'),
	'description' => __('Ex - &lt;link href="https://fonts.googleapis.com/css2?family=Kumbh+Sans:wght@300;400;700&display=swap" rel="stylesheet">', 'muy-lindo'),
	'section' => 'muy_fonts',
	'type'    => 'textarea',
);

?>